"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _user_privileges = require("../../../../common/components/user_privileges");
var _timeline = require("../../../../../common/types/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline2 = require("../../../store/timeline");
var _selectors = require("./selectors");
var _title_and_description = require("./title_and_description");
var timelineTranslations = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SaveTimelineButton = /*#__PURE__*/_react.default.memo(({
  initialFocus,
  timelineId,
  toolTip
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTimelineSaveModal = (0, _react.useMemo)(() => (0, _selectors.getTimelineSaveModalByIdSelector)(), []);
  const show = (0, _use_selector.useDeepEqualSelector)(state => getTimelineSaveModal(state, timelineId));
  const [showSaveTimelineOverlay, setShowSaveTimelineOverlay] = (0, _react.useState)(false);
  const closeSaveTimeline = (0, _react.useCallback)(() => {
    setShowSaveTimelineOverlay(false);
    if (show) {
      dispatch(_timeline2.timelineActions.toggleModalSaveTimeline({
        id: _timeline.TimelineId.active,
        showModalSaveTimeline: false
      }));
    }
  }, [dispatch, setShowSaveTimelineOverlay, show]);
  const openSaveTimeline = (0, _react.useCallback)(() => {
    setShowSaveTimelineOverlay(true);
  }, [setShowSaveTimelineOverlay]);

  // Case: 1
  // check if user has crud privileges so that user can be allowed to edit the timeline
  // Case: 2
  // TODO: User may have Crud privileges but they may not have access to timeline index.
  // Do we need to check that?
  const {
    kibanaSecuritySolutionsPrivileges: {
      crud: hasKibanaCrud
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const finalTooltipMsg = (0, _react.useMemo)(() => hasKibanaCrud ? toolTip : timelineTranslations.CALL_OUT_UNAUTHORIZED_MSG, [toolTip, hasKibanaCrud]);
  const saveTimelineButtonIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": timelineTranslations.EDIT,
    isDisabled: !hasKibanaCrud,
    onClick: openSaveTimeline,
    iconType: "pencil",
    "data-test-subj": "save-timeline-button-icon"
  }), [openSaveTimeline, hasKibanaCrud]);
  return initialFocus === 'title' && show || showSaveTimelineOverlay ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveTimelineButtonIcon, /*#__PURE__*/_react.default.createElement(_title_and_description.TimelineTitleAndDescription, {
    closeSaveTimeline: closeSaveTimeline,
    initialFocus: initialFocus,
    timelineId: timelineId,
    showWarning: initialFocus === 'title' && show
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: finalTooltipMsg !== null && finalTooltipMsg !== void 0 ? finalTooltipMsg : '',
    "data-test-subj": "save-timeline-btn-tooltip"
  }, saveTimelineButtonIcon);
});
exports.SaveTimelineButton = SaveTimelineButton;
SaveTimelineButton.displayName = 'SaveTimelineButton';