"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _data_providers = require("../data_providers");
var _search_or_filter = require("../search_or_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../../../../common/types/timeline/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineHeaderComponent = ({
  filterManager,
  show,
  showCallOutUnauthorizedMsg,
  status,
  timelineId
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCallOutUnauthorizedMsg && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  "data-test-subj": "timelineCallOutUnauthorized",
  title: i18n.CALL_OUT_UNAUTHORIZED_MSG,
  color: "warning",
  iconType: "warning",
  size: "s"
}), status === _api.TimelineStatus.immutable && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  "data-test-subj": "timelineImmutableCallOut",
  title: i18n.CALL_OUT_IMMUTABLE,
  color: "primary",
  iconType: "warning",
  size: "s"
}), show && /*#__PURE__*/_react.default.createElement(_data_providers.DataProviders, {
  timelineId: timelineId
}), /*#__PURE__*/_react.default.createElement(_search_or_filter.StatefulSearchOrFilter, {
  filterManager: filterManager,
  timelineId: timelineId
}));
const TimelineHeader = /*#__PURE__*/_react.default.memo(TimelineHeaderComponent);
exports.TimelineHeader = TimelineHeader;