"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataProviders = void 0;
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uuid = require("uuid");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_selector = require("../../../../common/hooks/use_selector");
var _droppable_wrapper = require("../../../../common/components/drag_and_drop/droppable_wrapper");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty = require("./empty");
var _providers = require("./providers");
var _timeline = require("../../../store/timeline");
var _defaults = require("../../../store/timeline/defaults");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DropTargetDataProvidersContainer = _styledComponents.default.div`
  padding: 2px 0 4px 0;

  .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & .drop-target-data-providers {
    background: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorSuccess, 0.1)};
    border: 0.2rem dashed ${({
  theme
}) => theme.eui.euiColorSuccess};

    & .timeline-drop-area-empty__text {
      color: ${({
  theme
}) => theme.eui.euiColorSuccess};
    }

    & .euiFormHelpText {
      color: ${({
  theme
}) => theme.eui.euiColorSuccess};
    }
  }
`;
const DropTargetDataProviders = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
  padding-bottom: 2px;
  position: relative;
  border: 0.2rem dashed ${({
  theme
}) => theme.eui.euiColorMediumShade};
  border-radius: 5px;
  padding: ${({
  theme
}) => theme.eui.euiSizeXS} 0;
  margin: 2px 0 2px 0;
  max-height: 33vh;
  min-height: 100px;
  overflow: auto;
  resize: vertical;
  background-color: ${({
  theme
}) => theme.eui.euiFormBackgroundColor};
`;
DropTargetDataProviders.displayName = 'DropTargetDataProviders';
const getDroppableId = id => `${_helpers.droppableTimelineProvidersPrefix}${id}${(0, _uuid.v4)()}`;

/**
 * Renders the data providers section of the timeline.
 *
 * The data providers section is a drop target where users
 * can drag-and drop new data providers into the timeline.
 *
 * It renders an interactive card representation of the
 * data providers. It also provides uniform
 * UI controls for the following actions:
 * 1) removing a data provider
 * 2) temporarily disabling a data provider
 * 3) applying boolean negation to the data provider
 *
 * Given an empty collection of DataProvider[], it prompts
 * the user to drop anything with a facet count into
 * the data pro section.
 */
const DataProviders = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const isLoading = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isLoading;
  });
  const dataProviders = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return ((_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults).dataProviders;
  });
  const droppableId = (0, _react.useMemo)(() => getDroppableId(timelineId), [timelineId]);
  return /*#__PURE__*/_react.default.createElement(DropTargetDataProvidersContainer, {
    "aria-label": i18n.QUERY_AREA_ARIA_LABEL,
    className: "drop-target-data-providers-container"
  }, /*#__PURE__*/_react.default.createElement(DropTargetDataProviders, {
    className: "drop-target-data-providers",
    "data-test-subj": "dataProviders"
  }, dataProviders != null && dataProviders.length ? /*#__PURE__*/_react.default.createElement(_providers.Providers, {
    browserFields: browserFields,
    timelineId: timelineId,
    dataProviders: dataProviders
  }) : /*#__PURE__*/_react.default.createElement(_droppable_wrapper.DroppableWrapper, {
    isDropDisabled: isLoading,
    droppableId: droppableId
  }, /*#__PURE__*/_react.default.createElement(_empty.Empty, {
    browserFields: browserFields,
    timelineId: timelineId
  }))));
});
exports.DataProviders = DataProviders;
DataProviders.displayName = 'DataProviders';