"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDirection = exports.SortIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _sort_number = require("./sort_number");
var _search_strategy = require("../../../../../../common/search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SortDirectionIndicatorEnum;
(function (SortDirectionIndicatorEnum) {
  SortDirectionIndicatorEnum["SORT_UP"] = "sortUp";
  SortDirectionIndicatorEnum["SORT_DOWN"] = "sortDown";
})(SortDirectionIndicatorEnum || (SortDirectionIndicatorEnum = {}));
/** Returns the symbol that corresponds to the specified `SortDirection` */
const getDirection = sortDirection => {
  switch (sortDirection) {
    case _search_strategy.Direction.asc:
      return SortDirectionIndicatorEnum.SORT_UP;
    case _search_strategy.Direction.desc:
      return SortDirectionIndicatorEnum.SORT_DOWN;
    case 'none':
      return undefined;
    default:
      throw new Error('Unhandled sort direction');
  }
};
exports.getDirection = getDirection;
/** Renders a sort indicator */
const SortIndicator = /*#__PURE__*/_react.default.memo(({
  sortDirection,
  sortNumber
}) => {
  const direction = getDirection(sortDirection);
  if (direction != null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: direction === SortDirectionIndicatorEnum.SORT_UP ? i18n.SORTED_ASCENDING : i18n.SORTED_DESCENDING,
      "data-test-subj": "sort-indicator-tooltip"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "sortIndicator",
      type: direction
    }), /*#__PURE__*/_react.default.createElement(_sort_number.SortNumber, {
      sortNumber: sortNumber
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "sortIndicator",
      type: 'empty'
    });
  }
});
exports.SortIndicator = SortIndicator;
SortIndicator.displayName = 'SortIndicator';