"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeekRowRenderer = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _api = require("../../../../../../../common/types/timeline/api");
var _row_renderer = require("../row_renderer");
var _zeek_details = require("./zeek_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zeekRowRenderer = {
  id: _api.RowRendererId.zeek,
  isInstance: ecs => {
    const module = (0, _fp.get)('event.module[0]', ecs);
    return module != null && module.toLowerCase() === 'zeek';
  },
  renderRow: ({
    data,
    isDraggable,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, null, /*#__PURE__*/_react.default.createElement(_zeek_details.ZeekDetails, {
    data: data,
    isDraggable: isDraggable,
    timelineId: scopeId
  }))
};
exports.zeekRowRenderer = zeekRowRenderer;