"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Package = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Package = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  isDraggable,
  packageName,
  packageSummary,
  packageVersion
}) => {
  if (packageName != null || packageSummary != null || packageVersion != null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "system.audit.package.name",
      isDraggable: isDraggable,
      value: packageName,
      iconType: "document",
      isAggregatable: true,
      fieldType: "keyword"
    })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "system.audit.package.version",
      isDraggable: isDraggable,
      value: packageVersion,
      iconType: "document",
      isAggregatable: true,
      fieldType: "keyword"
    })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "system.audit.package.summary",
      isDraggable: isDraggable,
      value: packageSummary,
      isAggregatable: true,
      fieldType: "keyword"
    })));
  } else {
    return null;
  }
});
exports.Package = Package;
Package.displayName = 'Package';