"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortIndex = exports.getSortDirection = exports.getNextSortDirection = exports.getNewSortDirectionOnClick = void 0;
var _search_strategy = require("../../../../../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Given a `header`, returns the `SortDirection` applicable to it */
const getNewSortDirectionOnClick = ({
  clickedHeader,
  currentSort
}) => currentSort.reduce((acc, item) => clickedHeader.id === item.columnId ? getNextSortDirection(item) : acc, _search_strategy.Direction.desc);

/** Given a current sort direction, it returns the next sort direction */
exports.getNewSortDirectionOnClick = getNewSortDirectionOnClick;
const getNextSortDirection = currentSort => {
  switch (currentSort.sortDirection) {
    case _search_strategy.Direction.desc:
      return _search_strategy.Direction.asc;
    case _search_strategy.Direction.asc:
      return _search_strategy.Direction.desc;
    case 'none':
      return _search_strategy.Direction.desc;
    default:
      return _search_strategy.Direction.desc;
  }
};
exports.getNextSortDirection = getNextSortDirection;
const getSortDirection = ({
  header,
  sort
}) => sort.reduce((acc, item) => header.id === item.columnId ? item.sortDirection : acc, 'none');
exports.getSortDirection = getSortDirection;
const getSortIndex = ({
  header,
  sort
}) => sort.findIndex(s => s.columnId === header.id);
exports.getSortIndex = getSortIndex;