"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetailsSidePanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _expandable_user = require("./expandable_user");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 1 0 auto;
`;
const StyledEuiFlexButtonWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-self: flex-start;
  flex: 1 0 auto;
`;
const StyledPanelContent = _styledComponents.default.div`
  display: block;
  height: 100%;
  overflow-y: scroll;
  overflow-x: hidden;
`;
const UserDetailsSidePanel = ({
  contextID,
  userName,
  isDraggable,
  handleOnClose
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
  justifyContent: "spaceBetween",
  wrap: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetailsTitle, {
  userName: userName
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  iconType: "cross",
  "aria-label": _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.networkDetails.close', {
    defaultMessage: 'close'
  }),
  onClick: handleOnClose
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(StyledEuiFlexButtonWrapper, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetailsPageLink, {
  userName: userName
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(StyledPanelContent, null, /*#__PURE__*/_react.default.createElement(_expandable_user.ExpandableUserDetails, {
  contextID: contextID,
  userName: userName,
  isDraggable: isDraggable
})));
exports.UserDetailsSidePanel = UserDetailsSidePanel;