"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetailsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _user_details_flyout = require("./user_details_flyout");
var _user_details_side_panel = require("./user_details_side_panel");
var _user_details_content = require("../new_user_detail/user_details_content");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserDetailsPanelComponent = ({
  contextID,
  userName,
  handleOnClose,
  isFlyoutView,
  isDraggable,
  isNewUserDetailsFlyoutEnable
}) => {
  if (isNewUserDetailsFlyoutEnable) {
    return isFlyoutView ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_user_details_content.UserDetailsContent, {
      userName: userName,
      contextID: contextID,
      isDraggable: isDraggable
    })) : /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-yScroll"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "cross",
      "aria-label": i18n.CLOSE_BUTTON,
      onClick: handleOnClose,
      css: (0, _react2.css)`
            float: right;
          `
    }), /*#__PURE__*/_react.default.createElement(_user_details_content.UserDetailsContent, {
      userName: userName,
      contextID: contextID,
      isDraggable: isDraggable
    }));
  }
  return isFlyoutView ? /*#__PURE__*/_react.default.createElement(_user_details_flyout.UserDetailsFlyout, {
    userName: userName,
    contextID: contextID
  }) : /*#__PURE__*/_react.default.createElement(_user_details_side_panel.UserDetailsSidePanel, {
    userName: userName,
    contextID: contextID,
    isDraggable: isDraggable,
    handleOnClose: handleOnClose
  });
};
const UserDetailsPanel = /*#__PURE__*/_react.default.memo(UserDetailsPanelComponent);
exports.UserDetailsPanel = UserDetailsPanel;