"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeaderContent = exports.FlyoutHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _expandable_event = require("../expandable_event");
var _back_to_alert_details_link = require("./back_to_alert_details_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeaderContentComponent = ({
  eventId,
  eventIndex,
  isAlert,
  isHostIsolationPanelOpen,
  isolateAction,
  loading,
  promptContextId,
  ruleName,
  showAlertDetails,
  timestamp
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isHostIsolationPanelOpen ? /*#__PURE__*/_react.default.createElement(_back_to_alert_details_link.BackToAlertDetailsLink, {
    isolateAction: isolateAction,
    showAlertDetails: showAlertDetails
  }) : /*#__PURE__*/_react.default.createElement(_expandable_event.ExpandableEventTitle, {
    eventId: eventId,
    eventIndex: eventIndex,
    isAlert: isAlert,
    loading: loading,
    promptContextId: promptContextId,
    ruleName: ruleName,
    timestamp: timestamp
  }));
};
const FlyoutHeaderContent = /*#__PURE__*/_react.default.memo(FlyoutHeaderContentComponent);
exports.FlyoutHeaderContent = FlyoutHeaderContent;
const FlyoutHeaderComponent = ({
  eventId,
  eventIndex,
  isAlert,
  isHostIsolationPanelOpen,
  isolateAction,
  loading,
  promptContextId,
  ruleName,
  showAlertDetails,
  timestamp
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: isHostIsolationPanelOpen
  }, /*#__PURE__*/_react.default.createElement(FlyoutHeaderContentComponent, {
    eventId: eventId,
    eventIndex: eventIndex,
    isAlert: isAlert,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isolateAction: isolateAction,
    loading: loading,
    promptContextId: promptContextId,
    ruleName: ruleName,
    showAlertDetails: showAlertDetails,
    timestamp: timestamp
  }));
};
const FlyoutHeader = /*#__PURE__*/_react.default.memo(FlyoutHeaderComponent);
exports.FlyoutHeader = FlyoutHeader;