"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowRenderersBrowser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _catalog = require("./catalog");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const StyledEuiInMemoryTable = (0, _styledComponents.default)(_eui.EuiInMemoryTable)`
  .euiTable {
    tr > *:last-child {
      display: none;
    }

    .euiTableHeaderCellCheckbox > .euiTableCellContent {
      display: none; // we don't want to display checkbox in the table
    }
  }
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: auto;

  > div {
    padding: 0;

    > div {
      margin: 0;
    }
  }
`;
const ExampleWrapperComponent = Example => {
  if (!Example) return;
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(Example, null));
};
const search = {
  box: {
    incremental: true,
    schema: true
  }
};

/**
 * Since `searchableDescription` contains raw text to power the Search bar,
 * this "noop" function ensures it's not actually rendered
 */
const renderSearchableDescriptionNoop = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const initialSorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const StyledNameButton = _styledComponents.default.button`
  text-align: left;
`;
const RowRenderersBrowserComponent = ({
  excludedRowRendererIds = [],
  setExcludedRowRendererIds
}) => {
  const handleNameClick = (0, _react.useCallback)(item => () => {
    const newSelection = (0, _fp.xor)([item.id], excludedRowRendererIds);
    setExcludedRowRendererIds(newSelection);
  }, [excludedRowRendererIds, setExcludedRowRendererIds]);
  const nameColumnRenderCallback = (0, _react.useCallback)((value, item) => /*#__PURE__*/_react.default.createElement(StyledNameButton, {
    className: "kbn-resetFocusState",
    onClick: handleNameClick(item)
  }, value), [handleNameClick]);
  const idColumnRenderCallback = (0, _react.useCallback)((_, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: item.id,
    onChange: handleNameClick(item),
    checked: !excludedRowRendererIds.includes(item.id)
  }), [excludedRowRendererIds, handleNameClick]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: '',
    sortable: false,
    width: '32px',
    render: idColumnRenderCallback
  }, {
    field: 'name',
    name: 'Name',
    sortable: true,
    width: '10%',
    render: nameColumnRenderCallback
  }, {
    field: 'description',
    name: 'Description',
    width: '25%',
    render: description => description
  }, {
    field: 'example',
    name: 'Example',
    width: '65%',
    render: ExampleWrapperComponent
  }, {
    field: 'searchableDescription',
    name: 'Searchable Description',
    sortable: false,
    width: '0px',
    render: renderSearchableDescriptionNoop
  }], [idColumnRenderCallback, nameColumnRenderCallback]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiInMemoryTable, {
    items: _catalog.renderers,
    itemId: "id",
    columns: columns,
    search: search,
    sorting: initialSorting,
    isSelectable: true
  });
};
RowRenderersBrowserComponent.displayName = 'RowRenderersBrowserComponent';
const RowRenderersBrowser = /*#__PURE__*/_react.default.memo(RowRenderersBrowserComponent);
exports.RowRenderersBrowser = RowRenderersBrowser;
RowRenderersBrowser.displayName = 'RowRenderersBrowser';