"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineShowStatusByIdSelector = void 0;
var _reselect = require("reselect");
var _timeline = require("../../../../common/types/timeline");
var _api = require("../../../../common/types/timeline/api");
var _timeline2 = require("../../store/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineShowStatusByIdSelector = () => (0, _reselect.createSelector)(_timeline2.timelineSelectors.selectTimeline, timeline => {
  var _timeline$activeTab, _timeline$status, _timeline$show, _timeline$updated;
  return {
    activeTab: (_timeline$activeTab = timeline === null || timeline === void 0 ? void 0 : timeline.activeTab) !== null && _timeline$activeTab !== void 0 ? _timeline$activeTab : _timeline.TimelineTabs.query,
    status: (_timeline$status = timeline === null || timeline === void 0 ? void 0 : timeline.status) !== null && _timeline$status !== void 0 ? _timeline$status : _api.TimelineStatus.draft,
    show: (_timeline$show = timeline === null || timeline === void 0 ? void 0 : timeline.show) !== null && _timeline$show !== void 0 ? _timeline$show : false,
    updated: (_timeline$updated = timeline === null || timeline === void 0 ? void 0 : timeline.updated) !== null && _timeline$updated !== void 0 ? _timeline$updated : undefined
  };
});
exports.getTimelineShowStatusByIdSelector = getTimelineShowStatusByIdSelector;