"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeaderPanel = exports.FlyoutHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _timeline2 = require("../../../store/timeline");
var _defaults = require("../../../store/timeline/defaults");
var _helpers = require("../../timeline/properties/helpers");
var _add_to_case_button = require("../add_to_case_button");
var _add_timeline_button = require("../add_timeline_button");
var _save_timeline_button = require("../../timeline/header/save_timeline_button");
var _kibana = require("../../../../common/lib/kibana");
var _inspect = require("../../../../common/components/inspect");
var _kpis = require("../../../containers/kpis");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _selectors = require("../../../../common/components/super_date_picker/selectors");
var _helpers2 = require("../../timeline/helpers");
var _kuery = require("../../../../common/lib/kuery");
var _model = require("../../../../common/store/sourcerer/model");
var _active_timelines = require("./active_timelines");
var i18n = _interopRequireWildcard(require("./translations"));
var commonI18n = _interopRequireWildcard(require("../../timeline/properties/translations"));
var _selectors2 = require("./selectors");
var _kpis2 = require("./kpis");
var _actions = require("../../../store/timeline/actions");
var _use_is_overflow = require("../../../../common/hooks/use_is_overflow");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveTimelinesContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
`;
const FlyoutHeaderPanelComponent = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    activeTab,
    dataProviders,
    kqlQuery,
    title,
    timelineType,
    status: timelineStatus,
    updated,
    show,
    filters,
    kqlMode
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['activeTab', 'dataProviders', 'kqlQuery', 'status', 'title', 'timelineType', 'updated', 'show', 'filters', 'kqlMode'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const isDataInTimeline = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(dataProviders) || !(0, _fp.isEmpty)((0, _fp.get)('filterQuery.kuery.expression', kqlQuery)), [dataProviders, kqlQuery]);
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getKqlFilterQuerySelector(), []);
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const kqlQueryTimeline = (0, _reactRedux.useSelector)(state => getKqlQueryTimeline(state, timelineId));
  const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(kqlQueryTimeline) && timelineType === 'template' ? ' ' : kqlQueryTimeline;
  const kqlQueryTest = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression,
    language: 'kuery'
  }), [kqlQueryExpression]);
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery: kqlQueryTest,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, filters, indexPattern, kqlMode, kqlQueryTest]);
  const handleClose = (0, _react.useCallback)(() => {
    dispatch(_timeline2.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
    (0, _helpers2.focusActiveTimelineButton)();
  }, [dispatch, timelineId]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    grow: false,
    paddingSize: "s",
    hasShadow: false,
    "data-test-subj": "timeline-flyout-header-panel",
    style: {
      backgroundColor: euiTheme.colors.emptyShade,
      color: euiTheme.colors.text
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_add_timeline_button.AddTimelineButton, {
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(ActiveTimelinesContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_active_timelines.ActiveTimelines, {
    timelineId: timelineId,
    timelineType: timelineType,
    timelineTitle: title,
    timelineStatus: timelineStatus,
    isOpen: show,
    updated: updated
  })), show && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    responsive: false
  }, (activeTab === _timeline.TimelineTabs.query || activeTab === _timeline.TimelineTabs.eql) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    compact: true,
    queryId: `${timelineId}-${activeTab}`,
    inputId: _constants.InputsModelId.timeline,
    inspectIndex: 0,
    isDisabled: !isDataInTimeline || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined,
    title: i18n.INSPECT_TIMELINE_TITLE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default'),
    "data-test-subj": "close-timeline",
    iconType: "cross",
    onClick: handleClose
  })))))));
};
const FlyoutHeaderPanel = /*#__PURE__*/_react.default.memo(FlyoutHeaderPanelComponent);
exports.FlyoutHeaderPanel = FlyoutHeaderPanel;
const StyledDiv = _styledComponents.default.div`
  display: -webkit-box;
  -webkit-line-clamp: 1;
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: break-word;
`;
const ReadMoreButton = ({
  description,
  onclick
}) => {
  const [isOverflow, ref] = (0, _use_is_overflow.useIsOverflow)(description);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledDiv, {
    ref: ref
  }, description), isOverflow && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    onClick: onclick
  }, i18n.READ_MORE));
};
const StyledTimelineHeader = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => `margin: ${theme.eui.euiSizeXS} ${theme.eui.euiSizeS} 0 ${theme.eui.euiSizeS};`}
  flex: 0;
`;
const TimelineStatusInfoContainer = _styledComponents.default.span`
  ${({
  theme
}) => `margin-left: ${theme.eui.euiSizeS};`}
  white-space: nowrap;
`;
const KpisContainer = _styledComponents.default.div`
  ${({
  theme
}) => `margin-right: ${theme.eui.euiSizeM};`}
`;
const RowFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  flex-direction: row;
  align-items: center;
`;
const TimelineTitleContainer = _styledComponents.default.h3`
  display: -webkit-box;
  overflow: hidden;
  -webkit-line-clamp: 1;
  -webkit-box-orient: vertical;
  word-break: break-word;
`;
const TimelineNameComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    title,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return (0, _fp.pick)(['title', 'timelineType'], (_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults);
  });
  const placeholder = (0, _react.useMemo)(() => timelineType === _api.TimelineType.template ? commonI18n.UNTITLED_TEMPLATE : commonI18n.UNTITLED_TIMELINE, [timelineType]);
  const content = (0, _react.useMemo)(() => title || placeholder, [title, placeholder]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: content,
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(TimelineTitleContainer, {
    "data-test-subj": "timeline-title"
  }, content)));
};
const TimelineName = /*#__PURE__*/_react.default.memo(TimelineNameComponent);
const TimelineDescriptionComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const description = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline3;
    return ((_getTimeline3 = getTimeline(state, timelineId)) !== null && _getTimeline3 !== void 0 ? _getTimeline3 : _defaults.timelineDefaults).description;
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const onReadMore = (0, _react.useCallback)(event => {
    dispatch((0, _actions.setActiveTabTimeline)({
      id: timelineId,
      activeTab: _timeline.TimelineTabs.notes,
      scrollToTop: true
    }));
  }, [dispatch, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "timeline-description"
  }, /*#__PURE__*/_react.default.createElement(ReadMoreButton, {
    description: description || commonI18n.DESCRIPTION,
    onclick: onReadMore
  }));
};
const TimelineDescription = /*#__PURE__*/_react.default.memo(TimelineDescriptionComponent);
const TimelineStatusInfoComponent = ({
  timelineId
}) => {
  const getTimelineStatus = (0, _react.useMemo)(() => (0, _selectors2.getTimelineStatusByIdSelector)(), []);
  const {
    status: timelineStatus,
    updated
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineStatus(state, timelineId));
  const isUnsaved = (0, _react.useMemo)(() => timelineStatus === _api.TimelineStatus.draft, [timelineStatus]);
  if (isUnsaved) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "warning",
      "data-test-subj": "timeline-status"
    }, i18n.UNSAVED));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default"
  }, i18n.AUTOSAVED, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    "data-test-subj": "timeline-status",
    key: "timeline-status-autosaved"
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    ,
    value: new Date(updated)
  })));
};
const TimelineStatusInfo = /*#__PURE__*/_react.default.memo(TimelineStatusInfoComponent);
const FlyoutHeaderComponent = ({
  timelineId
}) => {
  var _combinedQueries$filt;
  const {
    selectedPatterns,
    indexPattern,
    browserFields
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const getStartSelector = (0, _react.useMemo)(() => (0, _selectors.startSelector)(), []);
  const getEndSelector = (0, _react.useMemo)(() => (0, _selectors.endSelector)(), []);
  const isActive = (0, _react.useMemo)(() => timelineId === _timeline.TimelineId.active, [timelineId]);
  const timerange = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActive) {
      return {
        from: getStartSelector(state.inputs.timeline),
        to: getEndSelector(state.inputs.timeline),
        interval: ''
      };
    } else {
      return {
        from: getStartSelector(state.inputs.global),
        to: getEndSelector(state.inputs.global),
        interval: ''
      };
    }
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const timeline = (0, _reactRedux.useSelector)(state => {
    var _getTimeline4;
    return (_getTimeline4 = getTimeline(state, timelineId)) !== null && _getTimeline4 !== void 0 ? _getTimeline4 : _defaults.timelineDefaults;
  });
  const {
    dataProviders,
    filters,
    timelineType,
    kqlMode,
    activeTab
  } = timeline;
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getKqlFilterQuerySelector(), []);
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const kqlQueryTimeline = (0, _reactRedux.useSelector)(state => getKqlQueryTimeline(state, timelineId));
  const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(kqlQueryTimeline) && timelineType === 'template' ? ' ' : kqlQueryTimeline;
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression,
    language: 'kuery'
  }), [kqlQueryExpression]);
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, filters, indexPattern, kqlMode, kqlQuery]);
  const isBlankTimeline = (0, _react.useMemo)(() => (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined, [dataProviders, filters, kqlQuery, combinedQueries]);
  const [loading, kpis] = (0, _kpis.useTimelineKpis)({
    defaultIndex: selectedPatterns,
    timerange,
    isBlankTimeline,
    filterQuery: (_combinedQueries$filt = combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== null && _combinedQueries$filt !== void 0 ? _combinedQueries$filt : ''
  });
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  return /*#__PURE__*/_react.default.createElement(StyledTimelineHeader, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "properties-left",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(RowFlexItem, null, /*#__PURE__*/_react.default.createElement(TimelineName, {
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: timelineId,
    initialFocus: "title"
  }), /*#__PURE__*/_react.default.createElement(TimelineStatusInfoContainer, null, /*#__PURE__*/_react.default.createElement(TimelineStatusInfo, {
    timelineId: timelineId
  }))), /*#__PURE__*/_react.default.createElement(RowFlexItem, null, /*#__PURE__*/_react.default.createElement(TimelineDescription, {
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: timelineId,
    initialFocus: "description"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(KpisContainer, null, activeTab === _timeline.TimelineTabs.query ? /*#__PURE__*/_react.default.createElement(_kpis2.TimelineKPIs, {
    kpis: kpis,
    isLoading: loading
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_helpers.AddToFavoritesButton, {
    timelineId: timelineId
  })), userCasesPermissions.create && userCasesPermissions.read && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_case_button.AddToCaseButton, {
    timelineId: timelineId
  })))));
};
FlyoutHeaderComponent.displayName = 'FlyoutHeaderComponent';
const FlyoutHeader = /*#__PURE__*/_react.default.memo(FlyoutHeaderComponent);
exports.FlyoutHeader = FlyoutHeader;