"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinkProps = useLinkProps;
var _reactRedux = require("react-redux");
var _use_navigate_or_replace = require("./use_navigate_or_replace");
var selectors = _interopRequireWildcard(require("../store/selectors"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get an `onClick` function and an `href` string. Use these as props for `<a />` elements.
 * `onClick` will use navigate to the `panelViewAndParameters` using `history.push`.
 * the `href` points to `panelViewAndParameters`.
 * Existing `search` parameters are maintained.
 */
function useLinkProps(id, panelViewAndParameters) {
  const search = (0, _reactRedux.useSelector)(state => selectors.relativeHref(state.analyzer.analyzerById[id])(panelViewAndParameters));
  return (0, _use_navigate_or_replace.useNavigateOrReplace)({
    search
  });
}