"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlSearch = urlSearch;
var _rison = require("@kbn/rison");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Calculate the expected URL search based on options.
 */
function urlSearch(resolverComponentInstanceID, options) {
  if (!options) {
    return '';
  }
  const params = new URLSearchParams();
  params.set(`resolver-${resolverComponentInstanceID}`, (0, _rison.encode)(options));
  return params.toString();
}