"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var treeFetcherParameters = _interopRequireWildcard(require("../../models/tree_fetcher_parameters"));
var selectors = _interopRequireWildcard(require("./selectors"));
var nodeEventsInCategoryModel = _interopRequireWildcard(require("./node_events_in_category_model"));
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
var _helpers = require("../helpers");
var _actions = require("../actions");
var _action = require("./action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(_helpers.initialAnalyzerState).withHandling((0, _helpers.immerCase)(_actions.appReceivedNewExternalProperties, (draft, {
  id,
  resolverComponentInstanceID,
  locationSearch,
  databaseDocumentID,
  indices,
  filters
}) => {
  var _draft$analyzerById$i;
  const state = (_draft$analyzerById$i = draft.analyzerById[id]) === null || _draft$analyzerById$i === void 0 ? void 0 : _draft$analyzerById$i.data;
  state.tree = {
    ...state.tree,
    currentParameters: {
      databaseDocumentID,
      indices,
      filters
    }
  };
  state.resolverComponentInstanceID = resolverComponentInstanceID;
  state.locationSearch = locationSearch;
  state.indices = indices;
  const panelViewAndParameters = selectors.panelViewAndParameters(state);
  if (!state.nodeEventsInCategory || !nodeEventsInCategoryModel.isRelevantToPanelViewAndParameters(state.nodeEventsInCategory, panelViewAndParameters)) {
    state.nodeEventsInCategory = undefined;
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.appRequestedResolverData, (draft, {
  id,
  parameters
}) => {
  const state = draft.analyzerById[id].data;
  // keep track of what we're requesting, this way we know when to request and when not to.
  state.tree = {
    ...state.tree,
    pendingRequestParameters: {
      databaseDocumentID: parameters.databaseDocumentID,
      indices: parameters.indices,
      filters: parameters.filters
    }
  };
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.appAbortedResolverDataRequest, (draft, {
  id,
  parameters
}) => {
  var _state$tree;
  const state = draft.analyzerById[id].data;
  if (treeFetcherParameters.equal(parameters, (_state$tree = state.tree) === null || _state$tree === void 0 ? void 0 : _state$tree.pendingRequestParameters)) {
    // the request we were awaiting was aborted
    state.tree = {
      ...state.tree,
      pendingRequestParameters: undefined
    };
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverReturnedResolverData, (draft, {
  id,
  result,
  dataSource,
  schema,
  parameters,
  detectedBounds
}) => {
  const state = draft.analyzerById[id].data;
  /** Only handle this if we are expecting a response */
  state.tree = {
    ...state.tree,
    /**
     * Store the last received data, as well as the databaseDocumentID it relates to.
     */
    lastResponse: {
      result,
      dataSource,
      schema,
      parameters,
      successful: true
    },
    // This assumes that if we just received something, there is no longer a pending request.
    // This cannot model multiple in-flight requests
    pendingRequestParameters: undefined
  };
  state.detectedBounds = detectedBounds;
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverFailedToReturnResolverData, (draft, {
  id
}) => {
  var _state$tree2;
  /** Only handle this if we are expecting a response */
  const state = draft.analyzerById[id].data;
  if (((_state$tree2 = state.tree) === null || _state$tree2 === void 0 ? void 0 : _state$tree2.pendingRequestParameters) !== undefined) {
    var _state$tree3;
    state.tree = {
      ...state.tree,
      pendingRequestParameters: undefined,
      lastResponse: {
        parameters: (_state$tree3 = state.tree) === null || _state$tree3 === void 0 ? void 0 : _state$tree3.pendingRequestParameters,
        successful: false
      }
    };
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverReturnedNodeEventsInCategory, (draft, {
  id,
  events,
  cursor,
  nodeID,
  eventCategory
}) => {
  // The data in the action could be irrelevant if the panel view or parameters have changed since the corresponding request was made. In that case, ignore this action.
  const state = draft.analyzerById[id].data;
  if (nodeEventsInCategoryModel.isRelevantToPanelViewAndParameters({
    events,
    cursor,
    nodeID,
    eventCategory
  }, selectors.panelViewAndParameters(state))) {
    if (state.nodeEventsInCategory) {
      // If there are already `nodeEventsInCategory` in state then combine those with the new data in the payload.
      const updated = nodeEventsInCategoryModel.updatedWith(state.nodeEventsInCategory, {
        events,
        cursor,
        nodeID,
        eventCategory
      });
      // The 'updatedWith' method will fail if the old and new data don't represent events from the same node and event category
      if (updated) {
        state.nodeEventsInCategory = {
          ...updated
        };
      } else {
        // this should never happen. This reducer ensures that any `nodeEventsInCategory` that are in state: DataState are relevant to the `panelViewAndParameters`.
        throw new Error('Could not handle related event data because of an internal error.');
      }
    } else {
      // There is no existing data, use the new data.
      state.nodeEventsInCategory = {
        events,
        cursor,
        nodeID,
        eventCategory
      };
    }
    // else the action is stale, ignore it
  }

  return draft;
})).withHandling((0, _helpers.immerCase)(_action.userRequestedAdditionalRelatedEvents, (draft, {
  id
}) => {
  const state = draft.analyzerById[id].data;
  if (state.nodeEventsInCategory) {
    var _state$nodeEventsInCa;
    state.nodeEventsInCategory.lastCursorRequested = (_state$nodeEventsInCa = state.nodeEventsInCategory) === null || _state$nodeEventsInCa === void 0 ? void 0 : _state$nodeEventsInCa.cursor;
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverFailedToReturnNodeEventsInCategory, (draft, {
  id
}) => {
  const state = draft.analyzerById[id].data;
  if (state.nodeEventsInCategory) {
    state.nodeEventsInCategory = {
      ...state.nodeEventsInCategory,
      error: true
    };
  }
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverReturnedNodeData, (draft, {
  id,
  nodeData,
  requestedIDs,
  numberOfRequestedEvents
}) => {
  const state = draft.analyzerById[id].data;
  const updatedNodeData = nodeDataModel.updateWithReceivedNodes({
    storedNodeInfo: state.nodeData,
    receivedEvents: nodeData,
    requestedNodes: requestedIDs,
    numberOfRequestedEvents
  });
  state.nodeData = updatedNodeData;
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.userReloadedResolverNode, (draft, {
  id,
  nodeID
}) => {
  const state = draft.analyzerById[id].data;
  const updatedNodeData = nodeDataModel.setReloadedNodes(state.nodeData, nodeID);
  state.nodeData = updatedNodeData;
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.appRequestingNodeData, (draft, {
  id,
  requestedIDs
}) => {
  const state = draft.analyzerById[id].data;
  const updatedNodeData = nodeDataModel.setRequestedNodes(state.nodeData, requestedIDs);
  state.nodeData = updatedNodeData;
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverFailedToReturnNodeData, (draft, {
  id,
  requestedIDs
}) => {
  const state = draft.analyzerById[id].data;
  const updatedData = nodeDataModel.setErrorNodes(state.nodeData, requestedIDs);
  state.nodeData = updatedData;
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.appRequestedCurrentRelatedEventData, (draft, {
  id
}) => {
  draft.analyzerById[id].data.currentRelatedEvent = {
    loading: true,
    data: null
  };
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverReturnedCurrentRelatedEventData, (draft, {
  id,
  relatedEvent
}) => {
  draft.analyzerById[id].data.currentRelatedEvent = {
    loading: false,
    data: {
      ...relatedEvent
    }
  };
  return draft;
})).withHandling((0, _helpers.immerCase)(_action.serverFailedToReturnCurrentRelatedEventData, (draft, {
  id
}) => {
  draft.analyzerById[id].data.currentRelatedEvent = {
    loading: false,
    data: null
  };
  return draft;
})).build();
exports.dataReducer = dataReducer;