"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPanelViewAndParameters = void 0;
var schema = _interopRequireWildcard(require("./schema"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates an `unknown` value, narrowing it to `PanelViewAndParameters`.
 * Use this to validate that the value decoded from the URL is a valid `PanelViewAndParameters` object.
 */
const isPanelViewAndParameters = schema.oneOf([schema.object({
  panelView: schema.literal('nodes')
}), schema.object({
  panelView: schema.literal('nodeDetail'),
  panelParameters: schema.object({
    nodeID: schema.string()
  })
}), schema.object({
  panelView: schema.literal('nodeEvents'),
  panelParameters: schema.object({
    nodeID: schema.string()
  })
}), schema.object({
  panelView: schema.literal('nodeEventsInCategory'),
  panelParameters: schema.object({
    nodeID: schema.string(),
    eventCategory: schema.string()
  })
}), schema.object({
  panelView: schema.literal('eventDetail'),
  panelParameters: schema.object({
    nodeID: schema.string(),
    eventCategory: schema.string(),
    eventID: schema.oneOf([schema.string(), schema.literal(undefined), schema.number()]),
    eventTimestamp: schema.string(),
    winlogRecordID: schema.string()
  })
})]);
exports.isPanelViewAndParameters = isPanelViewAndParameters;