"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionResponse = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../common/store/inputs/constants");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _soc_trends = require("../components/detection_response/soc_trends");
var _search_bar = require("../../common/components/search_bar");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _sourcerer = require("../../common/containers/sourcerer");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_privileges = require("../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _header_page = require("../../common/components/header_page");
var _kibana = require("../../common/lib/kibana");
var _landing_page = require("../../common/components/landing_page");
var _alerts_by_status = require("../components/detection_response/alerts_by_status");
var _host_alerts_table = require("../components/detection_response/host_alerts_table");
var _rule_alerts_table = require("../components/detection_response/rule_alerts_table");
var _user_alerts_table = require("../components/detection_response/user_alerts_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _cases_table = require("../components/detection_response/cases_table");
var _cases_by_status = require("../components/detection_response/cases_by_status");
var _no_privileges = require("../../common/components/no_privileges");
var _filters_global = require("../../common/components/filters_global");
var _use_global_filter_query = require("../../common/hooks/use_global_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectionResponseComponent = () => {
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const {
    indicesExist,
    indexPattern,
    loading: isSourcererLoading
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadCases = (0, _kibana.useGetUserCasesPermissions)().read;
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const isSocTrendsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('socTrendsEnabled');
  if (!canReadAlerts && !canReadCases) {
    return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
      docLinkSelector: docLinks => docLinks.siem.privileges
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "detectionResponsePage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.DETECTION_RESPONSE_TITLE
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "detectionResponseLoader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "detectionResponseSections"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    additionalFilters: filterQuery ? [filterQuery] : undefined
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cases_by_status.CasesByStatus, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rule_alerts_table.RuleAlertsTable, {
    signalIndexName: signalIndexName
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cases_table.CasesTable, null)))), isSocTrendsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_soc_trends.SocTrends, {
    signalIndexName: signalIndexName
  })))), canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_host_alerts_table.HostAlertsTable, {
    signalIndexName: signalIndexName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_alerts_table.UserAlertsTable, {
    signalIndexName: signalIndexName
  }))))))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.detectionAndResponse
  }));
};
const DetectionResponse = /*#__PURE__*/_react.default.memo(DetectionResponseComponent);
exports.DetectionResponse = DetectionResponse;