"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _inspect = require("../../../common/components/inspect");
var _header_section = require("../../../common/components/header_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error TS2769
const StyledTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  [data-test-subj='panel-link'],
  [data-test-subj='panel-no-link'] {
    opacity: 0;
  }
  tr:hover {
    [data-test-subj='panel-link'],
    [data-test-subj='panel-no-link'] {
      opacity: 1;
    }
  }
`;
const PAGE_SIZE = 5;
const sortAndChunkItems = (listItems, sortField, sortDirection) => {
  const sortedItems = [...listItems].sort((a, b) => {
    const aSortValue = a[sortField];
    const bSortValue = b[sortField];
    if (typeof aSortValue !== 'undefined' && typeof bSortValue !== 'undefined') {
      if (aSortValue === bSortValue) {
        return a.title > b.title ? 1 : a.title < b.title ? -1 : 0;
      }
      return aSortValue > bSortValue ? 1 : aSortValue < bSortValue ? -1 : 0;
    }
    return 0;
  });
  if (sortDirection === 'desc') {
    sortedItems.reverse();
  }
  return (0, _lodash.chunk)(sortedItems, PAGE_SIZE);
};
const LinkPanelComponent = ({
  button,
  columns,
  dataTestSubj,
  defaultSortField,
  defaultSortOrder,
  infoPanel,
  inspectQueryId,
  listItems,
  panelTitle,
  splitPanel,
  subtitle
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [sortField, setSortField] = (0, _react.useState)(defaultSortField !== null && defaultSortField !== void 0 ? defaultSortField : 'title');
  const [sortDirection, setSortDirection] = (0, _react.useState)(defaultSortOrder !== null && defaultSortOrder !== void 0 ? defaultSortOrder : 'asc');
  const onTableChange = ({
    page,
    sort
  }) => {
    const {
      index
    } = page;
    setPageIndex(index);
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  const chunkedItems = (0, _react.useMemo)(() => sortAndChunkItems(listItems, sortField, sortDirection), [listItems, sortDirection, sortField]);
  const pagination = (0, _react.useMemo)(() => ({
    showPerPageOptions: false,
    pageIndex,
    pageSize: PAGE_SIZE,
    totalItemCount: listItems.length
  }), [pageIndex, listItems.length]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      direction: sortDirection,
      field: sortField
    }
  }), [sortField, sortDirection]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "spacer",
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "spaceBetween",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: inspectQueryId,
    subtitle: subtitle,
    title: panelTitle
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, button)), splitPanel, infoPanel, chunkedItems.length > 0 && /*#__PURE__*/_react.default.createElement(StyledTable, {
    columns: columns,
    itemId: "id",
    items: chunkedItems[pageIndex] || [],
    onChange: onTableChange,
    pagination: pagination,
    sorting: sorting
  }))))));
};
const LinkPanel = /*#__PURE__*/_react.default.memo(LinkPanelComponent);
exports.LinkPanel = LinkPanel;
LinkPanel.displayName = 'LinkPanel';