"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InnerLinkPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  padding: 0;
  margin-top: ${({
  theme
}) => theme.eui.euiSizeM};
  margin-left: 12px;
  transform: scale(${({
  color
}) => color === 'primary' ? 1.4 : 1});
`;
const PanelContainer = (0, _styledComponents.default)(_eui.EuiSplitPanel.Inner)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const Title = (0, _styledComponents.default)(_eui.EuiText)`
  color: ${({
  theme,
  textcolor
}) => textcolor === 'primary' ? theme.eui.euiColorPrimary : theme.eui.euiColorWarningText};
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const InnerLinkPanel = ({
  body,
  button,
  color,
  dataTestSubj,
  learnMoreLink,
  title
}) => /*#__PURE__*/_react.default.createElement(PanelContainer, {
  grow: false,
  color: color
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row"
}, /*#__PURE__*/_react.default.createElement(Icon, {
  type: color === 'primary' ? 'iInCircle' : 'help',
  size: "m",
  color: color
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Title, {
  "data-test-subj": "inner-link-panel-title",
  textcolor: color
}, title))), /*#__PURE__*/_react.default.createElement("p", null, body, ' ', learnMoreLink && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: learnMoreLink,
  target: "_blank",
  "data-test-subj": `${dataTestSubj}-learn-more`,
  external: true
}, i18n.LEARN_MORE))), button && /*#__PURE__*/_react.default.createElement(ButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, button))));
exports.InnerLinkPanel = InnerLinkPanel;
InnerLinkPanel.displayName = 'InnerLinkPanel';