"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ENTITY_RISK_TOOLTIP: true,
  ENTITY_NAME: true,
  VIEW_ALL: true,
  LEARN_MORE: true,
  HOST_RISK_TABLE_TOOLTIP: true,
  USER_RISK_TABLE_TOOLTIP: true
};
exports.VIEW_ALL = exports.USER_RISK_TABLE_TOOLTIP = exports.LEARN_MORE = exports.HOST_RISK_TABLE_TOOLTIP = exports.ENTITY_RISK_TOOLTIP = exports.ENTITY_NAME = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../../explore/components/risk_score/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_RISK_TOOLTIP = riskEntity => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.riskToolTip', {
  defaultMessage: '{riskEntity} risk classification is determined by {riskEntityLowercase} risk score. {riskEntity}s classified as Critical or High are indicated as risky.',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity),
    riskEntityLowercase: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.ENTITY_RISK_TOOLTIP = ENTITY_RISK_TOOLTIP;
const ENTITY_NAME = riskEntity => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.nameTitle', {
  defaultMessage: '{riskEntity} Name',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.ENTITY_NAME = ENTITY_NAME;
const VIEW_ALL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.viewAllLabel', {
  defaultMessage: 'View all'
});
exports.VIEW_ALL = VIEW_ALL;
const LEARN_MORE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.learnMore', {
  defaultMessage: 'Learn more'
});
exports.LEARN_MORE = LEARN_MORE;
const HOST_RISK_TABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.hostsTableTooltip', {
  defaultMessage: 'The Host Risk Score panel displays the list of risky hosts and their latest risk score. You may filter this list using global filters in the KQL search bar. The time-range picker filter will display Alerts within the selected time range only and does not filter the list of risky hosts.'
});
exports.HOST_RISK_TABLE_TOOLTIP = HOST_RISK_TABLE_TOOLTIP;
const USER_RISK_TABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.usersTableTooltip', {
  defaultMessage: 'The User Risk Score panel displays the list of risky users and their latest risk score. You may filter this list using global filters in the KQL search bar. The time-range picker filter will display Alerts within the selected time range only and does not filter the list of risky users.'
});
exports.USER_RISK_TABLE_TOOLTIP = USER_RISK_TABLE_TOOLTIP;