"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_risk_donut_chart_data = require("./use_risk_donut_chart_data");
var _donutchart_empty = require("../../../../common/components/charts/donutchart_empty");
var _common = require("../../../../explore/components/risk_score/severity/common");
var _donutchart = require("../../../../common/components/charts/donutchart");
var _legend = require("../../../../common/components/charts/legend");
var _chart_label = require("../../detection_response/alerts_by_status/chart_label");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DONUT_HEIGHT = 120;
const fillColor = dataName => {
  return Object.hasOwn(_common.RISK_SEVERITY_COLOUR, dataName) ? _common.RISK_SEVERITY_COLOUR[dataName] : _donutchart_empty.emptyDonutColor;
};
const DonutContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-right: ${({
  theme
}) => theme.eui.euiSizeXXL};
  padding-left: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const StyledLegendItems = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  justify-content: center;
`;
const RiskScoreDonutChart = ({
  severityCount
}) => {
  const [donutChartData, legendItems, total] = (0, _use_risk_donut_chart_data.useRiskDonutChartData)(severityCount);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    "data-test-subj": "risk-score-donut-chart"
  }, /*#__PURE__*/_react.default.createElement(StyledLegendItems, {
    grow: false
  }, legendItems.length > 0 && /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    legendItems: legendItems
  })), /*#__PURE__*/_react.default.createElement(DonutContainer, {
    grow: false,
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: donutChartData !== null && donutChartData !== void 0 ? donutChartData : null,
    fillColor: fillColor,
    height: DONUT_HEIGHT,
    label: i18n.TOTAL_LABEL,
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      count: total
    }),
    totalCount: total
  })));
};
exports.RiskScoreDonutChart = RiskScoreDonutChart;