"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnomaliesColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../../common/machine_learning/helpers");
var _total_anomalies = require("./components/total_anomalies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MediumShadeText = _styledComponents.default.span`
  color: ${({
  theme
}) => theme.eui.euiColorMediumShade};
`;
const useAnomaliesColumns = (loading, onJobEnabled, recentlyEnabledJobIds) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: i18n.ANOMALY_NAME,
    truncateText: true,
    mobileOptions: {
      show: true
    },
    'data-test-subj': 'anomalies-table-column-name',
    render: (jobName, {
      count,
      job
    }) => {
      if (count > 0 || job && ((0, _helpers.isJobStarted)(job.jobState, job.datafeedState) || recentlyEnabledJobIds.includes(job.id))) {
        return jobName;
      } else {
        return /*#__PURE__*/_react.default.createElement(MediumShadeText, null, jobName);
      }
    }
  }, {
    field: 'count',
    sortable: ({
      count,
      job
    }) => {
      if (count > 0) {
        return count;
      }
      if (job && (0, _helpers.isJobStarted)(job.jobState, job.datafeedState)) {
        return 0;
      }
      return -1;
    },
    truncateText: true,
    align: 'right',
    name: i18n.ANOMALY_COUNT,
    mobileOptions: {
      show: true
    },
    width: '15%',
    'data-test-subj': 'anomalies-table-column-count',
    render: (count, {
      entity,
      job
    }) => {
      if (!job) return '';
      return /*#__PURE__*/_react.default.createElement(_total_anomalies.TotalAnomalies, {
        count: count,
        job: job,
        entity: entity,
        loading: loading,
        onJobEnabled: onJobEnabled,
        recentlyEnabledJobIds: recentlyEnabledJobIds
      });
    }
  }], [loading, onJobEnabled, recentlyEnabledJobIds]);
  return columns;
};
exports.useAnomaliesColumns = useAnomaliesColumns;