"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _uuid = require("uuid");
var _use_selector = require("../../../../common/hooks/use_selector");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/store/sourcerer");
var _use_action_cell_data_provider = require("../../../../common/components/event_details/table/use_action_cell_data_provider");
var _timeline = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _use_create_timeline = require("../../../../timelines/components/timeline/properties/use_create_timeline");
var _actions = require("../../../../timelines/store/timeline/actions");
var _store = require("../../../../common/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToTimeline = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getDataViewsSelector = (0, _react.useMemo)(() => _store.sourcererSelectors.getSourcererDataViewsSelector(), []);
  const {
    defaultDataView,
    signalIndexName
  } = (0, _use_selector.useDeepEqualSelector)(state => getDataViewsSelector(state));
  const clearTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _api.TimelineType.default
  });
  const navigateToTimeline = (0, _react.useCallback)((dataProviders, timeRange) => {
    // Reset the current timeline
    clearTimeline({
      timeRange
    });
    // Update the timeline's providers to match the current prevalence field query
    dispatch((0, _actions.updateProviders)({
      id: _timeline.TimelineId.active,
      providers: dataProviders
    }));
    dispatch(_sourcerer.sourcererActions.setSelectedDataView({
      id: _model.SourcererScopeName.timeline,
      selectedDataViewId: defaultDataView.id,
      selectedPatterns: [signalIndexName || '']
    }));
  }, [clearTimeline, defaultDataView.id, dispatch, signalIndexName]);

  /** *
   * Open a timeline with the given filters prepopulated.
   * It accepts an array of Filter[]s where each item represents a set of AND queries, and each top level comma represents an OR.
   *
   * [[filter1 & filter2] OR [filter3 & filter4]]
   *
   * @param timeRange Defines the timeline time range field and removes the time range lock
   */
  const openTimelineWithFilters = (0, _react.useCallback)((filters, timeRange) => {
    const dataProviders = [];
    for (const orFilterGroup of filters) {
      const mainFilter = orFilterGroup[0];
      if (mainFilter) {
        const dataProvider = (0, _use_action_cell_data_provider.getDataProvider)(mainFilter.field, (0, _uuid.v4)(), mainFilter.value, mainFilter.operator);
        for (const filter of orFilterGroup.slice(1)) {
          dataProvider.and.push((0, _use_action_cell_data_provider.getDataProviderAnd)(filter.field, (0, _uuid.v4)(), filter.value, filter.operator));
        }
        dataProviders.push(dataProvider);
      }
    }
    navigateToTimeline(dataProviders, timeRange);
  }, [navigateToTimeline]);
  return {
    openTimelineWithFilters
  };
};
exports.useNavigateToTimeline = useNavigateToTimeline;