"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostFilter = exports.dataProviderWithOrFilters = exports.dataProviderWithOneFilter = exports.dataProviderWithAndFilters = exports.ORFilterGroup = exports.ANDFilterGroup1 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostFilter = {
  field: 'host.hostname',
  value: 'Host-u6ou715rzy'
};
exports.hostFilter = hostFilter;
const ANDFilterGroup1 = [hostFilter, {
  field: 'kibana.alerts.workflow_status',
  value: 'open'
}];
exports.ANDFilterGroup1 = ANDFilterGroup1;
const ANDFilterGroup2 = [hostFilter, {
  field: 'kibana.alerts.workflow_status',
  value: 'closed'
}];
const ANDFilterGroup3 = [hostFilter, {
  field: 'kibana.alerts.workflow_status',
  value: 'acknowledged'
}];
const ORFilterGroup = [ANDFilterGroup1, ANDFilterGroup2, ANDFilterGroup3];
exports.ORFilterGroup = ORFilterGroup;
const dataProviderWithOneFilter = [{
  and: [],
  enabled: true,
  id: 'mock-id',
  name: 'host.hostname',
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field: 'host.hostname',
    value: 'Host-u6ou715rzy',
    displayValue: 'Host-u6ou715rzy',
    operator: ':'
  }
}];
exports.dataProviderWithOneFilter = dataProviderWithOneFilter;
const dataProviderWithAndFilters = [{
  and: [{
    enabled: true,
    excluded: false,
    id: 'mock-id',
    kqlQuery: '',
    name: 'kibana.alerts.workflow_status',
    queryMatch: {
      field: 'kibana.alerts.workflow_status',
      operator: ':',
      value: 'open',
      displayValue: 'open'
    }
  }],
  enabled: true,
  id: 'mock-id',
  name: 'host.hostname',
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field: 'host.hostname',
    value: 'Host-u6ou715rzy',
    displayValue: 'Host-u6ou715rzy',
    operator: ':'
  }
}];
exports.dataProviderWithAndFilters = dataProviderWithAndFilters;
const dataProviderWithOrFilters = [{
  and: [{
    enabled: true,
    id: 'mock-id',
    name: 'kibana.alerts.workflow_status',
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field: 'kibana.alerts.workflow_status',
      value: 'open',
      displayValue: 'open',
      operator: ':'
    }
  }],
  enabled: true,
  id: 'mock-id',
  name: 'host.hostname',
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field: 'host.hostname',
    value: 'Host-u6ou715rzy',
    displayValue: 'Host-u6ou715rzy',
    operator: ':'
  }
}, {
  and: [{
    enabled: true,
    id: 'mock-id',
    name: 'kibana.alerts.workflow_status',
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field: 'kibana.alerts.workflow_status',
      value: 'closed',
      displayValue: 'closed',
      operator: ':'
    }
  }],
  enabled: true,
  id: 'mock-id',
  name: 'host.hostname',
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field: 'host.hostname',
    value: 'Host-u6ou715rzy',
    displayValue: 'Host-u6ou715rzy',
    operator: ':'
  }
}, {
  and: [{
    enabled: true,
    id: 'mock-id',
    name: 'kibana.alerts.workflow_status',
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field: 'kibana.alerts.workflow_status',
      value: 'acknowledged',
      displayValue: 'acknowledged',
      operator: ':'
    }
  }],
  enabled: true,
  id: 'mock-id',
  name: 'host.hostname',
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field: 'host.hostname',
    value: 'Host-u6ou715rzy',
    displayValue: 'Host-u6ou715rzy',
    operator: ':'
  }
}];
exports.dataProviderWithOrFilters = dataProviderWithOrFilters;