"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsByStatusVisualizationData = exports.openAlertsVisualizationId = exports.closedAlertsVisualizationId = exports.acknowledgedAlertsVisualizationId = void 0;
var _use_visualization_response = require("../../../../common/components/visualization_actions/use_visualization_response");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-open`;
exports.openAlertsVisualizationId = openAlertsVisualizationId;
const acknowledgedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}- acknowledged`;
exports.acknowledgedAlertsVisualizationId = acknowledgedAlertsVisualizationId;
const closedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-closed`;
exports.closedAlertsVisualizationId = closedAlertsVisualizationId;
const useAlertsByStatusVisualizationData = () => {
  var _ref;
  const openAlertsResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: openAlertsVisualizationId
  });
  const acknowledgedAlertsResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: acknowledgedAlertsVisualizationId
  });
  const closedAlertsResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: closedAlertsVisualizationId
  });
  const visualizationOpenAlertsData = openAlertsResponse != null ? openAlertsResponse[0].hits.total : 0;
  const visualizationAcknowledgedAlertsData = acknowledgedAlertsResponse != null ? acknowledgedAlertsResponse[0].hits.total : 0;
  const visualizationClosedAlertsData = closedAlertsResponse != null ? closedAlertsResponse[0].hits.total : 0;
  const visualizationTotalAlertsData = (_ref = visualizationOpenAlertsData + visualizationAcknowledgedAlertsData + visualizationClosedAlertsData) !== null && _ref !== void 0 ? _ref : 0;
  return {
    open: visualizationOpenAlertsData,
    acknowledged: visualizationAcknowledgedAlertsData,
    closed: visualizationClosedAlertsData,
    total: visualizationTotalAlertsData
  };
};
exports.useAlertsByStatusVisualizationData = useAlertsByStatusVisualizationData;