"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetEndpointSpecificPackagePolicies = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _ingest = require("./ingest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves a list of endpoint specific package policies (those created with a `package.name` of
 * `endpoint`) from Ingest
 * @param http
 * @param options
 */
const sendGetEndpointSpecificPackagePolicies = (http, options = {}) => {
  var _options$query;
  return http.get(_ingest.INGEST_API_PACKAGE_POLICIES, {
    ...options,
    query: {
      ...options.query,
      kuery: `${options !== null && options !== void 0 && (_options$query = options.query) !== null && _options$query !== void 0 && _options$query.kuery ? `${options.query.kuery} and ` : ''}${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: endpoint`
    }
  });
};
exports.sendGetEndpointSpecificPackagePolicies = sendGetEndpointSpecificPackagePolicies;