"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECT_OS_LABEL = exports.POLICY_SELECT_DESCRIPTION = exports.OPERATOR_TITLES = exports.NAME_LABEL = exports.INPUT_ERRORS = exports.ENTRY_PROPERTY_TITLES = exports.DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER = exports.DESCRIPTION_LABEL = exports.CONDITION_FIELD_TITLE = exports.CONDITION_FIELD_DESCRIPTION = exports.CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedApps.name.label', {
  defaultMessage: 'Name'
});
exports.NAME_LABEL = NAME_LABEL;
const DETAILS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedApps.details.header', {
  defaultMessage: 'Details'
});
exports.DETAILS_HEADER = DETAILS_HEADER;
const DETAILS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.details.header.description', {
  defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
});
exports.DETAILS_HEADER_DESCRIPTION = DETAILS_HEADER_DESCRIPTION;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.description', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const CONDITIONS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header', {
  defaultMessage: 'Conditions'
});
exports.CONDITIONS_HEADER = CONDITIONS_HEADER;
const CONDITIONS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header.description', {
  defaultMessage: 'Select an operating system and add conditions. Availability of conditions may depend on your chosen OS.'
});
exports.CONDITIONS_HEADER_DESCRIPTION = CONDITIONS_HEADER_DESCRIPTION;
const SELECT_OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedApps.os.label', {
  defaultMessage: 'Select operating system'
});
exports.SELECT_OS_LABEL = SELECT_OS_LABEL;
const CONDITION_FIELD_TITLE = {
  [_securitysolutionUtils.ConditionEntryField.HASH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.hash', {
    defaultMessage: 'Hash'
  }),
  [_securitysolutionUtils.ConditionEntryField.PATH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.path', {
    defaultMessage: 'Path'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.signature', {
    defaultMessage: 'Signature'
  })
};
exports.CONDITION_FIELD_TITLE = CONDITION_FIELD_TITLE;
const CONDITION_FIELD_DESCRIPTION = {
  [_securitysolutionUtils.ConditionEntryField.HASH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.hash', {
    defaultMessage: 'md5, sha1, or sha256'
  }),
  [_securitysolutionUtils.ConditionEntryField.PATH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.path', {
    defaultMessage: 'The full path of the application'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.signature', {
    defaultMessage: 'The signer of the application'
  })
};
exports.CONDITION_FIELD_DESCRIPTION = CONDITION_FIELD_DESCRIPTION;
const OPERATOR_TITLES = {
  is: _i18n.i18n.translate('xpack.securitySolution.trustedapps.card.operator.is', {
    defaultMessage: 'is'
  }),
  matches: _i18n.i18n.translate('xpack.securitySolution.trustedapps.card.operator.matches', {
    defaultMessage: 'matches'
  })
};
exports.OPERATOR_TITLES = OPERATOR_TITLES;
const ENTRY_PROPERTY_TITLES = {
  field: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.field', {
    defaultMessage: 'Field'
  }),
  operator: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.operator', {
    defaultMessage: 'Operator'
  }),
  value: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.value', {
    defaultMessage: 'Value'
  })
};
exports.ENTRY_PROPERTY_TITLES = ENTRY_PROPERTY_TITLES;
const POLICY_SELECT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.assignmentSectionDescription', {
  defaultMessage: 'Assign this trusted application globally across all policies, or assign it to specific policies.'
});
exports.POLICY_SELECT_DESCRIPTION = POLICY_SELECT_DESCRIPTION;
const INPUT_ERRORS = {
  name: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.nameRequiredMsg', {
    defaultMessage: 'Name is required'
  }),
  os: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.osRequiredMsg', {
    defaultMessage: 'Operating System is required'
  }),
  field: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionRequiredMsg', {
    defaultMessage: 'At least one Field definition is required'
  }),
  noDuplicateField: field => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldDuplicatedMsg', {
    defaultMessage: '{field} cannot be added more than once',
    values: {
      field: CONDITION_FIELD_TITLE[field]
    }
  }),
  mustHaveValue: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldValueRequiredMsg', {
    defaultMessage: '[{row}] Field entry must have a value',
    values: {
      row: index + 1
    }
  }),
  invalidHash: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldInvalidHashMsg', {
    defaultMessage: '[{row}] Invalid hash value',
    values: {
      row: index + 1
    }
  }),
  pathWarning: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldInvalidPathMsg', {
    defaultMessage: '[{row}] Path may be formed incorrectly; verify value',
    values: {
      row: index + 1
    }
  }),
  wildcardPathWarning: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldDegradedPerformanceMsg', {
    defaultMessage: `[{row}] A wildcard in the filename will affect the endpoint's performance`,
    values: {
      row: index + 1
    }
  })
};
exports.INPUT_ERRORS = INPUT_ERRORS;