"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _management_empty_state_wrapper = require("../../../../components/management_empty_state_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = /*#__PURE__*/(0, _react.memo)(({
  onAdd,
  isAddDisabled = false,
  backComponent
}) => {
  return /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "trustedAppEmptyState",
    iconType: "plusInCircle",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedapps.listEmptyState.title",
      defaultMessage: "Add your first trusted application"
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedapps.listEmptyState.message",
      defaultMessage: "Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts."
    }),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: isAddDisabled,
      onClick: onAdd,
      "data-test-subj": "trustedAppsListAddButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedapps.list.addButton",
      defaultMessage: "Add trusted application"
    })), ...(backComponent ? [backComponent] : [])]
  }));
});
exports.EmptyState = EmptyState;
EmptyState.displayName = 'EmptyState';