"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTabs = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _routing = require("../../../../common/routing");
var _kibana = require("../../../../../common/lib/kibana");
var _management_page_loader = require("../../../../components/management_page_loader");
var _selectors = require("../../store/policy_details/selectors");
var _policy_artifacts_layout = require("../artifacts/layout/policy_artifacts_layout");
var _components = require("../policy_forms/components");
var _policy_hooks = require("../policy_hooks");
var _event_filters_translations = require("./event_filters_translations");
var _trusted_apps_translations = require("./trusted_apps_translations");
var _host_isolation_exceptions_translations = require("./host_isolation_exceptions_translations");
var _blocklists_translations = require("./blocklists_translations");
var _api_client = require("../../../trusted_apps/service/api_client");
var _api_client2 = require("../../../event_filters/service/api_client");
var _blocklists_api_client = require("../../../blocklist/services/blocklists_api_client");
var _host_isolation_exceptions_api_client = require("../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _constants = require("../../../trusted_apps/constants");
var _constants2 = require("../../../event_filters/constants");
var _constants3 = require("../../../host_isolation_exceptions/constants");
var _constants4 = require("../../../blocklist/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var PolicyTabKeys;
(function (PolicyTabKeys) {
  PolicyTabKeys["SETTINGS"] = "settings";
  PolicyTabKeys["TRUSTED_APPS"] = "trustedApps";
  PolicyTabKeys["EVENT_FILTERS"] = "eventFilters";
  PolicyTabKeys["HOST_ISOLATION_EXCEPTIONS"] = "hostIsolationExceptions";
  PolicyTabKeys["BLOCKLISTS"] = "blocklists";
})(PolicyTabKeys || (PolicyTabKeys = {}));
const PolicyTabs = /*#__PURE__*/_react.default.memo(() => {
  const history = (0, _reactRouterDom.useHistory)();
  const http = (0, _kibana.useHttp)();
  const toasts = (0, _kibana.useToasts)();
  const isInSettingsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyFormView);
  const isInTrustedAppsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyTrustedAppsView);
  const isInEventFiltersTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyEventFiltersView);
  const isInHostIsolationExceptionsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnHostIsolationExceptionsView);
  const isInBlocklistsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnBlocklistsView);
  const policyId = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyIdFromParams);
  const policyItem = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const {
    canReadTrustedApplications,
    canWriteTrustedApplications,
    canReadEventFilters,
    canWriteEventFilters,
    canReadHostIsolationExceptions,
    canWriteHostIsolationExceptions,
    canReadBlocklist,
    canWriteBlocklist,
    loading: privilegesLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    state: routeState = {}
  } = (0, _reactRouterDom.useLocation)();

  // move the user out of this route if they can't access it
  (0, _react.useEffect)(() => {
    if (isInTrustedAppsTab && !canReadTrustedApplications || isInEventFiltersTab && !canReadEventFilters || isInHostIsolationExceptionsTab && !canReadHostIsolationExceptions || isInBlocklistsTab && !canReadBlocklist) {
      history.replace((0, _routing.getPolicyDetailPath)(policyId));
      toasts.addDanger(_i18n.i18n.translate('xpack.securitySolution.policyDetails.missingArtifactAccess', {
        defaultMessage: 'You do not have the required Kibana permissions to use the given artifact.'
      }));
    }
  }, [canReadBlocklist, canReadEventFilters, canReadHostIsolationExceptions, canReadTrustedApplications, history, isInBlocklistsTab, isInEventFiltersTab, isInHostIsolationExceptionsTab, isInTrustedAppsTab, policyId, toasts]);
  const getTrustedAppsApiClientInstance = (0, _react.useCallback)(() => _api_client.TrustedAppsApiClient.getInstance(http), [http]);
  const getEventFiltersApiClientInstance = (0, _react.useCallback)(() => _api_client2.EventFiltersApiClient.getInstance(http), [http]);
  const getHostIsolationExceptionsApiClientInstance = (0, _react.useCallback)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  const getBlocklistsApiClientInstance = (0, _react.useCallback)(() => _blocklists_api_client.BlocklistsApiClient.getInstance(http), [http]);
  const tabs = (0, _react.useMemo)(() => {
    const trustedAppsLabels = {
      ..._trusted_apps_translations.POLICY_ARTIFACT_TRUSTED_APPS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.trustedApps.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} trusted {count, plural, =1 {application} other {applications}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        }
      })
    };
    const eventFiltersLabels = {
      ..._event_filters_translations.POLICY_ARTIFACT_EVENT_FILTERS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.eventFilters.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} event {count, plural, =1 {filter} other {filters}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        }
      })
    };
    const hostIsolationExceptionsLabels = {
      ..._host_isolation_exceptions_translations.POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.hostIsolationExceptions.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} host isolation {count, plural, =1 {exception} other {exceptions}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        }
      })
    };
    const blocklistsLabels = {
      ..._blocklists_translations.POLICY_ARTIFACT_BLOCKLISTS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.blocklist.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} {count, plural, =1 {blocklist} other {blocklist entries}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        }
      })
    };
    return {
      [PolicyTabKeys.SETTINGS]: {
        id: PolicyTabKeys.SETTINGS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.policyForm', {
          defaultMessage: 'Policy settings'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.PolicyFormLayout, null))
      },
      [PolicyTabKeys.TRUSTED_APPS]: canReadTrustedApplications ? {
        id: PolicyTabKeys.TRUSTED_APPS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.trustedApps', {
          defaultMessage: 'Trusted applications'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: trustedAppsLabels,
          getExceptionsListApiClient: getTrustedAppsApiClientInstance,
          searchableFields: _constants.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getTrustedAppsListPath,
          getPolicyArtifactsPath: _routing.getPolicyDetailsArtifactsListPath,
          canWriteArtifact: canWriteTrustedApplications
        }))
      } : undefined,
      [PolicyTabKeys.EVENT_FILTERS]: canReadEventFilters ? {
        id: PolicyTabKeys.EVENT_FILTERS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.eventFilters', {
          defaultMessage: 'Event filters'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: eventFiltersLabels,
          getExceptionsListApiClient: getEventFiltersApiClientInstance,
          searchableFields: _constants2.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getEventFiltersListPath,
          getPolicyArtifactsPath: _routing.getPolicyEventFiltersPath,
          canWriteArtifact: canWriteEventFilters
        }))
      } : undefined,
      [PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS]: canReadHostIsolationExceptions ? {
        id: PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.isInHostIsolationExceptions', {
          defaultMessage: 'Host isolation exceptions'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: hostIsolationExceptionsLabels,
          getExceptionsListApiClient: getHostIsolationExceptionsApiClientInstance,
          searchableFields: _constants3.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getHostIsolationExceptionsListPath,
          getPolicyArtifactsPath: _routing.getPolicyHostIsolationExceptionsPath,
          canWriteArtifact: canWriteHostIsolationExceptions
        }))
      } : undefined,
      [PolicyTabKeys.BLOCKLISTS]: canReadBlocklist ? {
        id: PolicyTabKeys.BLOCKLISTS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.blocklists', {
          defaultMessage: 'Blocklist'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: blocklistsLabels,
          getExceptionsListApiClient: getBlocklistsApiClientInstance,
          searchableFields: _constants4.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getBlocklistsListPath,
          getPolicyArtifactsPath: _routing.getPolicyBlocklistsPath,
          canWriteArtifact: canWriteBlocklist
        }))
      } : undefined
    };
  }, [canReadTrustedApplications, canWriteTrustedApplications, canReadEventFilters, canWriteEventFilters, canReadHostIsolationExceptions, canWriteHostIsolationExceptions, canReadBlocklist, canWriteBlocklist, getEventFiltersApiClientInstance, getHostIsolationExceptionsApiClientInstance, getBlocklistsApiClientInstance, getTrustedAppsApiClientInstance, policyItem]);

  // convert tabs object into an array EuiTabbedContent can understand
  const tabsList = (0, _react.useMemo)(() => Object.values(tabs).filter(tab => tab !== undefined), [tabs]);
  const currentSelectedTab = (0, _react.useMemo)(() => {
    const defaultTab = tabs[PolicyTabKeys.SETTINGS];
    let selectedTab;
    if (isInSettingsTab) {
      selectedTab = tabs[PolicyTabKeys.SETTINGS];
    } else if (isInTrustedAppsTab) {
      selectedTab = tabs[PolicyTabKeys.TRUSTED_APPS];
    } else if (isInEventFiltersTab) {
      selectedTab = tabs[PolicyTabKeys.EVENT_FILTERS];
    } else if (isInHostIsolationExceptionsTab) {
      selectedTab = tabs[PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS];
    } else if (isInBlocklistsTab) {
      selectedTab = tabs[PolicyTabKeys.BLOCKLISTS];
    }
    return selectedTab || defaultTab;
  }, [tabs, isInSettingsTab, isInTrustedAppsTab, isInEventFiltersTab, isInHostIsolationExceptionsTab, isInBlocklistsTab]);
  const onTabClickHandler = (0, _react.useCallback)(selectedTab => {
    let path = '';
    switch (selectedTab.id) {
      case PolicyTabKeys.SETTINGS:
        path = (0, _routing.getPolicyDetailPath)(policyId);
        break;
      case PolicyTabKeys.TRUSTED_APPS:
        path = (0, _routing.getPolicyTrustedAppsPath)(policyId);
        break;
      case PolicyTabKeys.EVENT_FILTERS:
        path = (0, _routing.getPolicyEventFiltersPath)(policyId);
        break;
      case PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS:
        path = (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId);
        break;
      case PolicyTabKeys.BLOCKLISTS:
        path = (0, _routing.getPolicyBlocklistsPath)(policyId);
        break;
    }
    history.push(path, routeState !== null && routeState !== void 0 && routeState.backLink ? {
      backLink: routeState.backLink
    } : null);
  }, [history, policyId, routeState]);

  // show loader for privileges validation
  if (privilegesLoading) {
    return /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": "privilegesLoading"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabsList,
    selectedTab: currentSelectedTab,
    size: "l",
    onTabClick: onTabClickHandler
  });
});
exports.PolicyTabs = PolicyTabs;
PolicyTabs.displayName = 'PolicyTabs';