"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyEditExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _endpoint_policy_artifact_cards = require("./components/endpoint_policy_artifact_cards");
var _routing = require("../../../../../common/routing");
var _policy_details_form = require("../../policy_details_form");
var _policy_hooks = require("../../policy_hooks");
var _selectors = require("../../../store/policy_details/selectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Endpoint-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const EndpointPolicyEditExtension = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(WrappedPolicyDetailsForm, {
    policyId: policy.id,
    onChange: onChange
  }));
});
exports.EndpointPolicyEditExtension = EndpointPolicyEditExtension;
EndpointPolicyEditExtension.displayName = 'EndpointPolicyEditExtension';
const WrappedPolicyDetailsForm = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  onChange
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const updatedPolicy = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetailsForUpdate);
  const endpointPolicyDetails = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const endpointDetailsLoadingError = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.apiError);
  const [, setLastUpdatedPolicy] = (0, _react.useState)(updatedPolicy);

  // When the form is initially displayed, trigger the Redux middleware which is based on
  // the location information stored via the `userChangedUrl` action.
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'userChangedUrl',
      payload: {
        hash: '',
        pathname: (0, _routing.getPolicyDetailPath)(policyId, ''),
        search: ''
      }
    });

    // When form is unloaded, reset the redux store
    return () => {
      dispatch({
        type: 'userChangedUrl',
        payload: {
          hash: '',
          pathname: '/',
          search: ''
        }
      });
    };
  }, [dispatch, policyId]);
  (0, _react.useEffect)(() => {
    // Currently, the `onChange` callback provided by the fleet UI extension is regenerated every
    // time the policy data is updated, which means this will go into a continuous loop if we don't
    // actually check to see if an update should be reported back to fleet
    setLastUpdatedPolicy(prevState => {
      if (prevState === updatedPolicy) {
        return prevState;
      }
      if (updatedPolicy) {
        onChange({
          isValid: true,
          // send up only the updated policy data which is stored in the `inputs` section.
          // All other attributes (like name, id) are updated from the Fleet form, so we want to
          // ensure we don't override it.
          updatedPolicy: {
            // Casting is needed due to the use of `Immutable<>` in our store data
            inputs: updatedPolicy.inputs
          }
        });
      }
      return updatedPolicy;
    });
  }, [onChange, updatedPolicy]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "endpointIntegrationPolicyForm"
  }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_artifact_cards.EndpointPolicyArtifactCards, {
    policyId: policyId
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.settings.title",
    defaultMessage: "Policy settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), endpointDetailsLoadingError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetails.loadError",
      defaultMessage: "Failed to load endpoint policy settings"
    }),
    iconType: "warning",
    color: "warning",
    "data-test-subj": "endpiontPolicySettingsLoadingError"
  }, endpointDetailsLoadingError.message) : !endpointPolicyDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    className: "essentialAnimation"
  }) : /*#__PURE__*/_react.default.createElement(_policy_details_form.PolicyDetailsForm, null)));
});
WrappedPolicyDetailsForm.displayName = 'WrappedPolicyDetailsForm';