"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _styledComponents = require("styled-components");
var _policy_hooks = require("../../policy_hooks");
var _selectors = require("../../../store/policy_details/selectors");
var _config_form = require("../config_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPERATING_SYSTEM_TO_TEST_SUBJ = {
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: 'Windows',
  [_securitysolutionUtils.OperatingSystem.LINUX]: 'Linux',
  [_securitysolutionUtils.OperatingSystem.MAC]: 'Mac'
};
const InnerEventsForm = ({
  os,
  options,
  selection,
  onValueSelection,
  supplementalOptions
}) => {
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const countSelected = (0, _react.useCallback)(() => {
    const supplementalSelectionFields = supplementalOptions ? supplementalOptions.map(value => value.protectionField) : [];
    return Object.entries(selection).filter(([key, value]) => !supplementalSelectionFields.includes(key) ? value : false).length;
  }, [selection, supplementalOptions]);
  return /*#__PURE__*/_react.default.createElement(_config_form.ConfigForm, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollection', {
      defaultMessage: 'Event collection'
    }),
    supportedOss: [os],
    rightCorner: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollectionsEnabled', {
      defaultMessage: '{selected} / {total} event collections enabled',
      values: {
        selected: countSelected(),
        total: options.length
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_config_form.ConfigFormHeading, null, _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.eventingEvents', {
    defaultMessage: 'Events'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), options.map(({
    name,
    protectionField
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      key: String(protectionField),
      id: (0, _eui.htmlIdGenerator)()(),
      label: name,
      "data-test-subj": `policy${OPERATING_SYSTEM_TO_TEST_SUBJ[os]}Event_${protectionField}`,
      checked: selection[protectionField],
      onChange: event => onValueSelection(protectionField, event.target.checked),
      disabled: !showEditableFormFields
    });
  }), supplementalOptions && supplementalOptions.map(({
    title,
    description,
    name,
    protectionField,
    tooltipText,
    beta,
    indented,
    isDisabled
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: String(protectionField),
      style: indented ? {
        paddingLeft: theme.eui.euiSizeL
      } : {}
    }, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_config_form.ConfigFormHeading, null, title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: (0, _eui.htmlIdGenerator)()(),
      label: name,
      "data-test-subj": `policy${OPERATING_SYSTEM_TO_TEST_SUBJ[os]}Event_${protectionField}`,
      checked: selection[protectionField],
      onChange: event => onValueSelection(protectionField, event.target.checked),
      disabled: !showEditableFormFields || (isDisabled ? isDisabled(policyDetailsConfig) : false)
    })), tooltipText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: tooltipText
    })), beta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "beta",
      size: "s"
    }))));
  }));
};
InnerEventsForm.displayName = 'EventsForm';
const EventsForm = /*#__PURE__*/_react.default.memo(InnerEventsForm);
exports.EventsForm = EventsForm;