"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementCategories = exports.ManageLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../app/types");
var _header_page = require("../../common/components/header_page");
var _nav_links = require("../../common/links/nav_links");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _landing_links_icons = require("../../common/components/landing_links/landing_links_icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MANAGE_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.management.landing.pageTitle', {
  defaultMessage: 'Manage'
});
const ManageLandingPage = () => /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
  title: MANAGE_PAGE_TITLE
}), /*#__PURE__*/_react.default.createElement(ManagementCategories, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _types.SecurityPageName.administration
}));
exports.ManageLandingPage = ManageLandingPage;
const StyledEuiHorizontalRule = (0, _styledComponents.default)(_eui.EuiHorizontalRule)`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeM};
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const useManagementCategories = () => {
  var _useRootNavLink;
  const {
    links = [],
    categories = []
  } = (_useRootNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.administration)) !== null && _useRootNavLink !== void 0 ? _useRootNavLink : {};
  const manageLinksById = Object.fromEntries(links.map(link => [link.id, link]));
  return categories.reduce((acc, {
    label,
    linkIds
  }) => {
    const linksItem = linkIds.reduce((linksAcc, linkId) => {
      if (manageLinksById[linkId]) {
        linksAcc.push(manageLinksById[linkId]);
      }
      return linksAcc;
    }, []);
    if (linksItem.length > 0) {
      acc.push({
        label,
        links: linksItem
      });
    }
    return acc;
  }, []);
};
const ManagementCategories = () => {
  const managementCategories = useManagementCategories();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, managementCategories.map(({
    label,
    links
  }, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: label
  }, index > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    key: "first",
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    key: "second",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, label)), /*#__PURE__*/_react.default.createElement(StyledEuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_landing_links_icons.LandingLinksIcons, {
    items: links
  }))));
};
exports.ManagementCategories = ManagementCategories;
ManagementCategories.displayName = 'ManagementCategories';