"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsFlyoutHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _selectors = require("../../../store/selectors");
var _back_to_endpoint_details_flyout_subheader = require("./back_to_endpoint_details_flyout_subheader");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointDetailsFlyoutHeader = /*#__PURE__*/(0, _react.memo)(({
  endpointId,
  hasBorder = false,
  hostname,
  children
}) => {
  const hostDetailsLoading = (0, _hooks.useEndpointSelector)(_selectors.detailsLoading);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: hasBorder
  }, endpointId && /*#__PURE__*/_react.default.createElement(_back_to_endpoint_details_flyout_subheader.BackToEndpointDetailsFlyoutSubHeader, {
    endpointId: endpointId
  }), hostDetailsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: hostname,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      overflow: 'hidden',
      textOverflow: 'ellipsis'
    },
    "data-test-subj": "endpointDetailsFlyoutTitle"
  }, hostname))), children);
});
exports.EndpointDetailsFlyoutHeader = EndpointDetailsFlyoutHeader;
EndpointDetailsFlyoutHeader.displayName = 'EndpointDetailsFlyoutHeader';