"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFileInfo = void 0;
var _reactQuery = require("@tanstack/react-query");
var _get_file_download_id = require("../../../../common/endpoint/service/response_actions/get_file_download_id");
var _resolve_path_variables = require("../../../common/utils/resolve_path_variables");
var _hooks = require("../../../common/lib/kibana/hooks");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves information about a file that was uploaded by the endpoint as a result of a `get-file` action
 * @param action
 * @param [agentId] If left undefined, the first agent that the action was sent to will be used
 * @param [options]
 */
const useGetFileInfo = (action, agentId, options = {}) => {
  const http = (0, _hooks.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-action-file-info', action.id, agentId !== null && agentId !== void 0 ? agentId : action.agents[0]],
    ...options,
    queryFn: () => {
      const apiUrl = (0, _resolve_path_variables.resolvePathVariables)(_constants.ACTION_AGENT_FILE_INFO_ROUTE, {
        action_id: action.id,
        file_id: (0, _get_file_download_id.getFileDownloadId)(action, agentId)
      });
      return http.get(apiUrl);
    }
  });
};
exports.useGetFileInfo = useGetFileInfo;