"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionFileDownloadLink = exports.FILE_TRUNCATED_MESSAGE = exports.FILE_PASSCODE_INFO_MESSAGE = exports.FILE_NO_LONGER_AVAILABLE_MESSAGE = exports.FILE_DELETED_MESSAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _get_file_download_id = require("../../../../common/endpoint/service/response_actions/get_file_download_id");
var _resolve_path_variables = require("../../../common/utils/resolve_path_variables");
var _formatted_error = require("../formatted_error");
var _use_get_file_info = require("../../hooks/response_actions/use_get_file_info");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _constants = require("../../../../common/endpoint/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STYLE_INHERIT_FONT_FAMILY = Object.freeze({
  fontFamily: 'inherit'
});
const DEFAULT_BUTTON_TITLE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.downloadButtonLabel', {
  defaultMessage: 'Click here to download'
});
const FILE_NO_LONGER_AVAILABLE_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileNoLongerAvailable', {
  defaultMessage: 'File has expired and is no longer available for download.'
});
exports.FILE_NO_LONGER_AVAILABLE_MESSAGE = FILE_NO_LONGER_AVAILABLE_MESSAGE;
const FILE_DELETED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.deleteNotice', {
  defaultMessage: 'Files are periodically deleted to clear storage space. Download and save file locally if needed.'
});
exports.FILE_DELETED_MESSAGE = FILE_DELETED_MESSAGE;
const FILE_PASSCODE_INFO_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.passcodeInfo', {
  defaultMessage: '(ZIP file passcode: {passcode}).',
  values: {
    passcode: 'elastic'
  }
});
exports.FILE_PASSCODE_INFO_MESSAGE = FILE_PASSCODE_INFO_MESSAGE;
const FILE_TRUNCATED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileTruncated', {
  defaultMessage: 'Output data in the provided zip file is truncated due to file size limitations.'
});
exports.FILE_TRUNCATED_MESSAGE = FILE_TRUNCATED_MESSAGE;
const FileDownloadLinkContainer = _styledComponents.default.div`
  & > * {
    vertical-align: middle;
  }
`;
const TruncatedTextInfo = /*#__PURE__*/(0, _react.memo)(({
  textSize,
  'data-test-subj': dataTestSubj
}) => {
  const alertIconSize = (0, _react.useMemo)(() => textSize === 'xs' ? 's' : 'm', [textSize]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: alertIconSize,
    type: "warning",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    color: "warning",
    "data-test-subj": dataTestSubj
  }, FILE_TRUNCATED_MESSAGE))));
});
TruncatedTextInfo.displayName = 'TruncatedTextInfo';
/**
 * Displays the download link for a file retrieved via a Response Action. The download link
 * button will only be displayed if the user has authorization to use file operations.
 *
 * NOTE: Currently displays only the link for the first host in the Action
 */
const ResponseActionFileDownloadLink = /*#__PURE__*/(0, _react.memo)(({
  action: _action,
  agentId,
  buttonTitle = DEFAULT_BUTTON_TITLE,
  canAccessFileDownloadLink,
  isTruncatedFile = false,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  var _error$response;
  const action = _action; // cast to remove `Immutable`
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const shouldFetchFileInfo = (0, _react.useMemo)(() => {
    return action.isCompleted && action.wasSuccessful;
  }, [action.isCompleted, action.wasSuccessful]);
  const downloadUrl = (0, _react.useMemo)(() => {
    return (0, _resolve_path_variables.resolvePathVariables)(_constants.ACTION_AGENT_FILE_DOWNLOAD_ROUTE, {
      action_id: action.id,
      file_id: (0, _get_file_download_id.getFileDownloadId)(action, agentId)
    });
  }, [action, agentId]);
  const {
    isFetching,
    data: fileInfo,
    error
  } = (0, _use_get_file_info.useGetFileInfo)(action, undefined, {
    enabled: canAccessFileDownloadLink && shouldFetchFileInfo
  });
  if (!canAccessFileDownloadLink || !action.isCompleted || !action.wasSuccessful) {
    return null;
  }
  if (isFetching) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      "data-test-subj": getTestId('loading')
    });
  }

  // Check if file is no longer available
  if (error && (error === null || error === void 0 ? void 0 : (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 404 || (fileInfo === null || fileInfo === void 0 ? void 0 : fileInfo.data.status) === 'DELETED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: textSize,
      color: "warning",
      "data-test-subj": getTestId('fileNoLongerAvailable')
    }, FILE_NO_LONGER_AVAILABLE_MESSAGE);
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: error,
      "data-test-subj": getTestId('apiError')
    });
  }
  return /*#__PURE__*/_react.default.createElement(FileDownloadLinkContainer, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: downloadUrl,
    iconType: "download",
    "data-test-subj": getTestId('downloadButton'),
    flush: "left",
    style: STYLE_INHERIT_FONT_FAMILY,
    iconSize: "s",
    download: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize
  }, buttonTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": getTestId('passcodeMessage'),
    className: "eui-displayInline"
  }, FILE_PASSCODE_INFO_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    color: "warning",
    "data-test-subj": getTestId('fileDeleteMessage')
  }, FILE_DELETED_MESSAGE), isTruncatedFile && /*#__PURE__*/_react.default.createElement(TruncatedTextInfo, {
    textSize: textSize,
    "data-test-subj": getTestId('fileTruncatedMessage')
  }));
});
exports.ResponseActionFileDownloadLink = ResponseActionFileDownloadLink;
ResponseActionFileDownloadLink.displayName = 'ResponseActionFileDownloadLink';