"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointUploadActionResult = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react2 = require("@emotion/react");
var _endpoint_action_failure_message = require("../endpoint_action_failure_message");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LABELS = Object.freeze({
  path: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.savedTo', {
    defaultMessage: 'File saved to'
  }),
  disk_free_space: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.freeDiskSpace', {
    defaultMessage: 'Free disk space on drive'
  }),
  noAgentResponse: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.missingAgentResult', {
    defaultMessage: 'Error: Agent result missing'
  }),
  host: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.host', {
    defaultMessage: 'Host'
  })
});
const EndpointUploadActionResult = /*#__PURE__*/(0, _react.memo)(({
  action: _action,
  agentId,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  const action = _action;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const outputs = (0, _react.useMemo)(() => {
    const hosts = [];
    const agents = agentId ? [agentId] : action.agents;
    for (const agent of agents) {
      var _action$outputs;
      hosts.push({
        name: action.hosts[agent].name,
        state: action.agentState[agent],
        result: (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : _action$outputs[agent]
      });
    }
    return hosts;
  }, [action.agentState, action.agents, action.hosts, action.outputs, agentId]);
  const showHostName = outputs.length > 1;
  if (action.command !== 'upload') {
    window.console.warn(`EndpointUploadActionResult: called with a non-upload action`);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (outputs.length === 0) {
    window.console.warn(`EndpointUploadActionResult: Agent id [${agentId}] not in list of agents for action`);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": getTestId(),
    size: textSize
  }, outputs.map(({
    name,
    state,
    result
  }) => {
    // Use case: action log
    if (!state.isCompleted) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('pending'),
        key: name
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpointUploadActionResult.pendingMessage",
        defaultMessage: "Action pending."
      }));
    }

    // if we don't have an agent result (for whatever reason)
    if (!result) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('noResultError'),
        key: name
      }, LABELS.noAgentResponse);
    }

    // Error result
    if (!state.wasSuccessful) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('actionFailure'),
        key: name
      }, /*#__PURE__*/_react.default.createElement(_endpoint_action_failure_message.EndpointActionFailureMessage, {
        action: action
      }));
    }
    return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
      name: showHostName ? name : undefined,
      "data-test-subj": getTestId('success'),
      key: name
    }, /*#__PURE__*/_react.default.createElement(KeyValueDisplay, {
      name: LABELS.path,
      value: result.content.path
    }), /*#__PURE__*/_react.default.createElement(KeyValueDisplay, {
      name: LABELS.disk_free_space,
      value: (0, _numeral.default)(result.content.disk_free_space).format('0.00b')
    }));
  }));
});
exports.EndpointUploadActionResult = EndpointUploadActionResult;
EndpointUploadActionResult.displayName = 'EndpointUploadActionResult';
const KeyValueDisplay = /*#__PURE__*/(0, _react.memo)(({
  name,
  value
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    css: (0, _react2.css)`
        white-space: pre-wrap;
      `
  }, /*#__PURE__*/_react.default.createElement("strong", null, name, ': '), value);
});
KeyValueDisplay.displayName = 'KeyValueDisplay';
const HostUploadResult = /*#__PURE__*/(0, _react.memo)(({
  name,
  children,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, name && /*#__PURE__*/_react.default.createElement(KeyValueDisplay, {
    name: LABELS.host,
    value: name
  }), children, name && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
});
HostUploadResult.displayName = 'HostUploadResult';