"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionSuccess = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _endpoint_action_response_codes = require("../lib/endpoint_action_response_codes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display generic success message for all actions
 */
const ActionSuccess = /*#__PURE__*/(0, _react.memo)(({
  action,
  ResultComponent,
  title: _title,
  ...props
}) => {
  const title = (0, _react.useMemo)(() => {
    var _action$outputs, _action$outputs$first, _action$outputs$first2;
    if (_title) {
      return _title;
    }
    const firstAgentId = action.agents[0];
    const actionOutputCode = (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : (_action$outputs$first = _action$outputs[firstAgentId]) === null || _action$outputs$first === void 0 ? void 0 : (_action$outputs$first2 = _action$outputs$first.content) === null || _action$outputs$first2 === void 0 ? void 0 : _action$outputs$first2.code;
    return actionOutputCode ? _endpoint_action_response_codes.endpointActionResponseCodes[actionOutputCode] : undefined;
  }, [_title, action.agents, action.outputs]);
  return /*#__PURE__*/_react.default.createElement(ResultComponent, (0, _extends2.default)({}, props, {
    title: title
  }));
});
exports.ActionSuccess = ActionSuccess;
ActionSuccess.displayName = 'ActionSuccess';