"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERROR_TITLE = exports.ERROR_MESSAGE = exports.CORRELATIONS_TEXT = exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERT = exports.CORRELATIONS_SAME_SESSION_ALERTS = exports.CORRELATIONS_SAME_SESSION_ALERT = exports.CORRELATIONS_RELATED_CASES = exports.CORRELATIONS_RELATED_CASE = exports.CORRELATIONS_ANCESTRY_ALERTS = exports.CORRELATIONS_ANCESTRY_ALERT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = title => _i18n.i18n.translate('xpack.securitySolution.flyout.errorTitle', {
  values: {
    title
  },
  defaultMessage: 'Unable to display {title}'
});
exports.ERROR_TITLE = ERROR_TITLE;
const ERROR_MESSAGE = message => _i18n.i18n.translate('xpack.securitySolution.flyout.errorMessage', {
  values: {
    message
  },
  defaultMessage: 'There was an error displaying {message}'
});
exports.ERROR_MESSAGE = ERROR_MESSAGE;
const CORRELATIONS_TEXT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlationsText', {
  defaultMessage: 'fields of correlation'
});
exports.CORRELATIONS_TEXT = CORRELATIONS_TEXT;
const CORRELATIONS_ANCESTRY_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.ancestryAlert', {
  defaultMessage: 'alert related by ancestry'
});
exports.CORRELATIONS_ANCESTRY_ALERT = CORRELATIONS_ANCESTRY_ALERT;
const CORRELATIONS_ANCESTRY_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.ancestryAlerts', {
  defaultMessage: 'alerts related by ancestry'
});
exports.CORRELATIONS_ANCESTRY_ALERTS = CORRELATIONS_ANCESTRY_ALERTS;
const CORRELATIONS_SAME_SOURCE_EVENT_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSourceEventAlert', {
  defaultMessage: 'alert related by the same source event'
});
exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERT = CORRELATIONS_SAME_SOURCE_EVENT_ALERT;
const CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSourceEventAlerts', {
  defaultMessage: 'alerts related by the same source event'
});
exports.CORRELATIONS_SAME_SOURCE_EVENT_ALERTS = CORRELATIONS_SAME_SOURCE_EVENT_ALERTS;
const CORRELATIONS_SAME_SESSION_ALERT = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSessionAlert', {
  defaultMessage: 'alert related by session'
});
exports.CORRELATIONS_SAME_SESSION_ALERT = CORRELATIONS_SAME_SESSION_ALERT;
const CORRELATIONS_SAME_SESSION_ALERTS = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.sameSessionAlerts', {
  defaultMessage: 'alerts related by session'
});
exports.CORRELATIONS_SAME_SESSION_ALERTS = CORRELATIONS_SAME_SESSION_ALERTS;
const CORRELATIONS_RELATED_CASE = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.relatedCase', {
  defaultMessage: 'related case'
});
exports.CORRELATIONS_RELATED_CASE = CORRELATIONS_RELATED_CASE;
const CORRELATIONS_RELATED_CASES = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.overviewTab.correlations.relatedCases', {
  defaultMessage: 'related cases'
});
exports.CORRELATIONS_RELATED_CASES = CORRELATIONS_RELATED_CASES;