"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_fetch_threat_intelligence = require("../hooks/use_fetch_threat_intelligence");
var _insights_subsection = require("./insights_subsection");
var _insights_summary_row = require("./insights_summary_row");
var _context = require("../context");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _left = require("../../left");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Threat Intelligence section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const ThreatIntelligenceOverview = () => {
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const goToThreatIntelligenceTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      path: _left.LeftPanelInsightsTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    loading: threatIntelLoading,
    error: threatIntelError,
    threatMatchesCount,
    threatEnrichmentsCount
  } = (0, _use_fetch_threat_intelligence.useFetchThreatIntelligence)({
    dataFormattedForFieldBrowser
  });
  const error = !eventId || !dataFormattedForFieldBrowser || threatIntelError;
  return /*#__PURE__*/_react.default.createElement(_insights_subsection.InsightsSubSection, {
    error: error,
    title: _translations.THREAT_INTELLIGENCE_TITLE,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: threatIntelLoading,
    error: error,
    icon: 'warning',
    value: threatMatchesCount,
    text: threatMatchesCount <= 1 ? _translations.THREAT_MATCH_DETECTED : _translations.THREAT_MATCHES_DETECTED,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: threatIntelLoading,
    error: error,
    icon: 'warning',
    value: threatEnrichmentsCount,
    text: threatEnrichmentsCount <= 1 ? _translations.THREAT_ENRICHMENT : _translations.THREAT_ENRICHMENTS,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: goToThreatIntelligenceTab,
    iconType: "arrowStart",
    iconSide: "left",
    size: "s",
    "data-test-subj": `${_test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID}ViewAllButton`
  }, (0, _translations.VIEW_ALL)(_translations.THREAT_INTELLIGENCE_TEXT)));
};
exports.ThreatIntelligenceOverview = ThreatIntelligenceOverview;
ThreatIntelligenceOverview.displayName = 'ThreatIntelligenceOverview';