"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttack = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _test_ids = require("./test_ids");
var _get_mitre_threat_component = require("../../../detections/mitre/get_mitre_threat_component");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MitreAttack = () => {
  const {
    searchHit
  } = (0, _context.useRightPanelContext)();
  const threatDetails = (0, _react.useMemo)(() => (0, _get_mitre_threat_component.getMitreComponentParts)(searchHit), [searchHit]);
  if (!threatDetails || !threatDetails[0]) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.MITRE_ATTACK_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, threatDetails[0].title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.MITRE_ATTACK_DETAILS_TEST_ID
  }, threatDetails[0].description));
};
exports.MitreAttack = MitreAttack;
MitreAttack.displayName = 'MitreAttack';