"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _expandable_section = require("./expandable_section");
var _highlighted_fields = require("./highlighted_fields");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _investigation_guide_button = require("./investigation_guide_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Most top section of the overview tab. It contains the description, reason and mitre attack information (for a document of type alert).
 */
const InvestigationSection = ({
  expanded = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: _translations.INVESTIGATION_TITLE,
    "data-test-subj": _test_ids.INVESTIGATION_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_investigation_guide_button.InvestigationGuideButton, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_highlighted_fields.HighlightedFields, null));
};
exports.InvestigationSection = InvestigationSection;
InvestigationSection.displayName = 'InvestigationSection';