"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _context = require("../context");
var _left = require("../../left");
var _translations = require("./translations");
var _test_ids = require("./test_ids");
var _analyzer_helpers = require("../utils/analyzer_helpers");
var _translations2 = require("../../shared/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Analyzer tree that represent a summary view of analyzer. It shows current process, and its parent and child processes
 */
const AnalyzerTree = ({
  statsNodes,
  loading,
  error
}) => {
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const items = (0, _react.useMemo)(() => (0, _analyzer_helpers.getTreeNodes)(statsNodes !== null && statsNodes !== void 0 ? statsNodes : []), [statsNodes]);
  const goToAnalyserTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      path: _left.LeftPanelVisualizeTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": _test_ids.ANALYZER_TREE_LOADING_TEST_ID
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations2.ERROR_TITLE)(_translations.ANALYZER_PREVIEW_TEXT)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations2.ERROR_MESSAGE)(_translations.ANALYZER_PREVIEW_TEXT)),
      "data-test-subj": _test_ids.ANALYZER_TREE_ERROR_TEST_ID
    });
  }
  if (items && items.length !== 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      paddingSize: "none",
      "data-test-subj": _test_ids.ANALYZER_TREE_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      iconType: "sessionViewer",
      onClick: goToAnalyserTab,
      "data-test-subj": _test_ids.ANALYZER_TREE_VIEW_DETAILS_BUTTON_TEST_ID
    }, _translations.ANALYZER_PREVIEW_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView, {
      items: items,
      display: "compressed",
      "aria-label": _translations.ANALYZER_PREVIEW_TITLE
    })));
  }
  return null;
};
exports.AnalyzerTree = AnalyzerTree;
AnalyzerTree.displayName = 'AnalyzerTree';