"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _use_alert_prevalence_from_process_tree = require("../../../common/containers/alerts/use_alert_prevalence_from_process_tree");
var _analyzer_tree = require("./analyzer_tree");
var _helpers = require("../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Analyzer preview under Overview, Visualizations. It shows a tree representation of analyzer.
 */
const AnalyzerPreview = () => {
  var _index$values;
  const [cache, setCache] = (0, _react.useState)({});
  const {
    dataFormattedForFieldBrowser: data,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const documentId = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.ancestors.id'
  }, data);
  const processDocumentId = documentId && Array.isArray(documentId.values) ? documentId.values[0] : '';
  const index = (0, _fp.find)({
    category: 'kibana',
    field: 'kibana.alert.rule.parameters.index'
  }, data);
  const indices = (_index$values = index === null || index === void 0 ? void 0 : index.values) !== null && _index$values !== void 0 ? _index$values : [];
  const {
    loading,
    error,
    statsNodes
  } = (0, _use_alert_prevalence_from_process_tree.useAlertPrevalenceFromProcessTree)({
    isActiveTimeline: (0, _helpers.isActiveTimeline)(scopeId),
    documentId: processDocumentId,
    indices
  });
  (0, _react.useEffect)(() => {
    if (statsNodes && statsNodes.length !== 0) {
      setCache({
        statsNodes
      });
    }
  }, [statsNodes, setCache]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ANALYZER_PREVIEW_TEST_ID
  }, documentId && index && /*#__PURE__*/_react.default.createElement(_analyzer_tree.AnalyzerTree, {
    statsNodes: cache.statsNodes,
    loading: loading,
    error: error
  }));
};
exports.AnalyzerPreview = AnalyzerPreview;
AnalyzerPreview.displayName = 'AnalyzerPreview';