"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LeftPanelVisualizeTabPath = exports.LeftPanelKey = exports.LeftPanelInvestigationTabPath = exports.LeftPanelInsightsTabPath = exports.LeftPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _header = require("./header");
var _content = require("./content");
var _tabs = require("./tabs");
var _context = require("./context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LeftPanelKey = 'document-details-left';
exports.LeftPanelKey = LeftPanelKey;
const LeftPanelVisualizeTabPath = ['visualize'];
exports.LeftPanelVisualizeTabPath = LeftPanelVisualizeTabPath;
const LeftPanelInsightsTabPath = ['insights'];
exports.LeftPanelInsightsTabPath = LeftPanelInsightsTabPath;
const LeftPanelInvestigationTabPath = ['investigation'];
exports.LeftPanelInvestigationTabPath = LeftPanelInvestigationTabPath;
const LeftPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabs$map$find;
    const defaultTab = _tabs.tabs[0].id;
    if (!path) return defaultTab;
    return (_tabs$map$find = _tabs.tabs.map(tab => tab.id).find(tabId => tabId === path[0])) !== null && _tabs$map$find !== void 0 ? _tabs$map$find : defaultTab;
  }, [path]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: LeftPanelKey,
      path: [tabId],
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        height: 100%;
        background: ${(0, _eui.useEuiBackgroundColor)('subdued')};
      `
  }, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    selectedTabId: selectedTabId
  }));
});
exports.LeftPanel = LeftPanel;
LeftPanel.displayName = 'LeftPanel';