"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceDetails = exports.THREAT_INTELLIGENCE_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _isEmpty = _interopRequireDefault(require("lodash/isEmpty"));
var _enrichment_range_picker = require("../../../common/components/event_details/cti_details/enrichment_range_picker");
var _threat_details_view = require("../../../common/components/event_details/cti_details/threat_details_view");
var _use_threat_intelligence_details = require("../hooks/use_threat_intelligence_details");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THREAT_INTELLIGENCE_TAB_ID = 'threat-intelligence-details';

/**
 * Threat intelligence displayed in the document details expandable flyout left section under the Insights tab
 */
exports.THREAT_INTELLIGENCE_TAB_ID = THREAT_INTELLIGENCE_TAB_ID;
const ThreatIntelligenceDetails = () => {
  const {
    enrichments,
    eventFields,
    isEnrichmentsLoading,
    isEventDataLoading,
    isLoading,
    range,
    setRange
  } = (0, _use_threat_intelligence_details.useThreatIntelligenceDetails)();
  if (isEventDataLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": _test_ids.THREAT_INTELLIGENCE_DETAILS_SPINNER_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_details_view.ThreatDetailsView, {
    before: null,
    loading: isLoading,
    enrichments: enrichments,
    showInvestigationTimeEnrichments: !(0, _isEmpty.default)(eventFields)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_enrichment_range_picker.EnrichmentRangePicker, {
    setRange: setRange,
    loading: isEnrichmentsLoading,
    range: range
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
};
exports.ThreatIntelligenceDetails = ThreatIntelligenceDetails;
ThreatIntelligenceDetails.displayName = 'ThreatIntelligenceDetails';