"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseDetails = exports.RESPONSE_TAB_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _test_ids = require("./test_ids");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _context = require("../context");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _osquery_tab = require("../../../common/components/event_details/osquery_tab");
var _response_actions_view = require("../../../common/components/event_details/response_actions_view");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESPONSE_TAB_ID = 'response-details';
exports.RESPONSE_TAB_ID = RESPONSE_TAB_ID;
const ExtendedFlyoutWrapper = _styledComponents.default.div`
 figure {
  background-color: white
`;
const InlineBlock = _styledComponents.default.div`
  display: inline-block;
  line-height: 1.7em;
`;

/**
 * Automated response actions results, displayed in the document details expandable flyout left section under the Insights tab, Response tab
 */
const ResponseDetails = () => {
  var _expandedEventFieldsO, _expandedEventFieldsO2, _expandedEventFieldsO3, _expandedEventFieldsO4;
  const {
    searchHit,
    dataAsNestedObject
  } = (0, _context.useLeftPanelContext)();
  const endpointResponseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const expandedEventFieldsObject = searchHit ? (0, _expand_dotted.expandDottedObject)(searchHit.fields) : undefined;
  const responseActions = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO === void 0 ? void 0 : (_expandedEventFieldsO2 = _expandedEventFieldsO.alert) === null || _expandedEventFieldsO2 === void 0 ? void 0 : (_expandedEventFieldsO3 = _expandedEventFieldsO2.rule) === null || _expandedEventFieldsO3 === void 0 ? void 0 : (_expandedEventFieldsO4 = _expandedEventFieldsO3.parameters) === null || _expandedEventFieldsO4 === void 0 ? void 0 : _expandedEventFieldsO4[0].response_actions;
  const responseActionsView = (0, _response_actions_view.useResponseActionsView)({
    rawEventData: searchHit,
    ecsData: dataAsNestedObject
  });
  const osqueryView = (0, _osquery_tab.useOsqueryTab)({
    rawEventData: searchHit,
    ecsData: dataAsNestedObject
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.RESPONSE_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.RESPONSE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !responseActions ? /*#__PURE__*/_react.default.createElement(InlineBlock, {
    "data-test-subj": _test_ids.RESPONSE_EMPTY_TEST_ID
  }, i18n.RESPONSE_EMPTY) : /*#__PURE__*/_react.default.createElement(ExtendedFlyoutWrapper, null, endpointResponseActionsEnabled ? responseActionsView === null || responseActionsView === void 0 ? void 0 : responseActionsView.content : osqueryView === null || osqueryView === void 0 ? void 0 : osqueryView.content));
};
exports.ResponseDetails = ResponseDetails;
ResponseDetails.displayName = 'ResponseDetails';