"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceDetails = exports.PREVALENCE_TAB_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../shared/translations");
var _translations2 = require("./translations");
var _test_ids = require("./test_ids");
var _prevalence_details_count_cell = require("./prevalence_details_count_cell");
var _prevalence_details_prevalence_cell = require("./prevalence_details_prevalence_cell");
var _get_alert_summary_rows = require("../../../common/components/event_details/get_alert_summary_rows");
var _context = require("../context");
var _use_fetch_field_value_pair_by_event_type = require("../../shared/hooks/use_fetch_field_value_pair_by_event_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREVALENCE_TAB_ID = 'prevalence-details';
exports.PREVALENCE_TAB_ID = PREVALENCE_TAB_ID;
const columns = [{
  field: 'type',
  name: _translations2.PREVALENCE_TABLE_TYPE_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_TYPE_CELL_TEST_ID
}, {
  field: 'name',
  name: _translations2.PREVALENCE_TABLE_NAME_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_NAME_CELL_TEST_ID
}, {
  field: 'alertCount',
  name: _translations2.PREVALENCE_TABLE_ALERT_COUNT_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_ALERT_COUNT_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_prevalence_details_count_cell.PrevalenceDetailsCountCell, {
    highlightedField: data.highlightedField,
    scopeId: data.scopeId,
    type: {
      eventKind: _use_fetch_field_value_pair_by_event_type.EventKind.signal,
      include: true
    }
  })
}, {
  field: 'docCount',
  name: _translations2.PREVALENCE_TABLE_DOC_COUNT_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_DOC_COUNT_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_prevalence_details_count_cell.PrevalenceDetailsCountCell, {
    highlightedField: data.highlightedField,
    scopeId: data.scopeId,
    type: {
      eventKind: _use_fetch_field_value_pair_by_event_type.EventKind.signal,
      exclude: true
    }
  })
}, {
  field: 'hostPrevalence',
  name: _translations2.PREVALENCE_TABLE_HOST_PREVALENCE_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_HOST_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_prevalence_details_prevalence_cell.PrevalenceDetailsPrevalenceCell, {
    highlightedField: data.highlightedField,
    scopeId: data.scopeId,
    aggregationField: 'host.name'
  })
}, {
  field: 'userPrevalence',
  name: _translations2.PREVALENCE_TABLE_USER_PREVALENCE_COLUMN_TITLE,
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_USER_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_prevalence_details_prevalence_cell.PrevalenceDetailsPrevalenceCell, {
    highlightedField: data.highlightedField,
    scopeId: data.scopeId,
    aggregationField: 'user.name'
  })
}];

/**
 * Prevalence table displayed in the document details expandable flyout left section under the Insights tab
 */
const PrevalenceDetails = () => {
  const {
    browserFields,
    dataFormattedForFieldBrowser,
    eventId,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const data = (0, _react.useMemo)(() => {
    const summaryRows = (0, _get_alert_summary_rows.getSummaryRows)({
      browserFields: browserFields || {},
      data: dataFormattedForFieldBrowser || [],
      eventId,
      scopeId,
      isReadOnly: false
    });
    const getCellRenderFields = summaryRow => ({
      highlightedField: {
        name: summaryRow.description.data.field,
        values: summaryRow.description.values || []
      },
      scopeId
    });
    return (summaryRows || []).map(summaryRow => {
      const fields = getCellRenderFields(summaryRow);
      return {
        type: summaryRow.description.data.field,
        name: summaryRow.description.values,
        alertCount: fields,
        docCount: fields,
        hostPrevalence: fields,
        userPrevalence: fields
      };
    });
  }, [browserFields, dataFormattedForFieldBrowser, eventId, scopeId]);
  if (!eventId || !dataFormattedForFieldBrowser || !browserFields || !data || data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations.ERROR_TITLE)(_translations2.PREVALENCE_ERROR_MESSAGE)),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.ERROR_MESSAGE)(_translations2.PREVALENCE_ERROR_MESSAGE)),
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_ERROR_TEST_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: "",
    items: data,
    columns: columns,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_TEST_ID
  });
};
exports.PrevalenceDetails = PrevalenceDetails;
PrevalenceDetails.displayName = 'PrevalenceDetails';