"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _entity_panel = require("../../right/components/entity_panel");
var _host_overview = require("../../../overview/components/host_overview");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _inspect = require("../../../common/components/inspect");
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
var _common = require("../../../explore/components/risk_score/severity/common");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
var _constants = require("../../../common/store/inputs/constants");
var _cell_actions = require("../../../common/components/cell_actions");
var _use_global_time = require("../../../common/containers/use_global_time");
var _sourcerer = require("../../../common/containers/sourcerer");
var _manage_query = require("../../../common/components/page/manage_query");
var _score_interval_to_datetime = require("../../../common/components/ml/score/score_interval_to_datetime");
var _actions = require("../../../common/store/inputs/actions");
var _host_to_criteria = require("../../../common/components/ml/criteria/host_to_criteria");
var _details = require("../../../explore/hosts/containers/hosts/details");
var _related_users = require("../../../common/containers/related_entities/related_users");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_value = require("../../../common/components/empty_value");
var _test_ids = require("./test_ids");
var _translations = require("../../../explore/components/risk_score/translations");
var _translations2 = require("../../../explore/users/components/all_users/translations");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_DETAILS_ID = 'entities-hosts-details';
const RELATED_USERS_ID = 'entities-hosts-related-users';
const HostOverviewManage = (0, _manage_query.manageQuery)(_host_overview.HostOverview);
const RelatedUsersManage = (0, _manage_query.manageQuery)(_inspect.InspectButtonContainer);
/**
 * Host details and related users, displayed in the document details expandable flyout left section under the Insights tab, Entities tab
 */
const HostDetails = ({
  hostName,
  timestamp
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  // create a unique, but stable (across re-renders) query id
  const hostDetailsQueryId = (0, _react.useMemo)(() => `${HOST_DETAILS_ID}-${(0, _uuid.v4)()}`, []);
  const relatedUsersQueryId = (0, _react.useMemo)(() => `${RELATED_USERS_ID}-${(0, _uuid.v4)()}`, []);
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const [isHostLoading, {
    inspect,
    hostDetails,
    refetch
  }] = (0, _details.useHostDetails)({
    id: hostDetailsQueryId,
    startDate: from,
    endDate: to,
    hostName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const {
    loading: isRelatedUsersLoading,
    inspect: inspectRelatedUsers,
    relatedUsers,
    totalCount,
    refetch: refetchRelatedUsers
  } = (0, _related_users.useHostRelatedUsers)({
    hostName,
    indexNames: selectedPatterns,
    from: timestamp,
    // related users are users who were successfully authenticated onto this host AFTER alert time
    skip: selectedPatterns.length === 0
  });
  const relatedUsersColumns = (0, _react.useMemo)(() => [{
    field: 'user',
    name: i18n.RELATED_ENTITIES_NAME_COLUMN_TITLE,
    render: user => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      visibleCellActions: 5,
      showActionTooltips: true,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      field: {
        name: 'user.name',
        value: user,
        type: 'keyword'
      }
    }, user))
  }, {
    field: 'ip',
    name: i18n.RELATED_ENTITIES_IP_COLUMN_TITLE,
    render: ips => {
      return /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
        rowItems: ips,
        attrName: 'host.ip',
        idPrefix: '',
        isDraggable: false,
        render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
          ip: ip
        }) : (0, _empty_value.getEmptyTagValue)()
      });
    }
  }, ...(isPlatinumOrTrialLicense ? [{
    field: 'risk',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations2.USER_RISK_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _translations.ENTITY_RISK_CLASSIFICATION)(_search_strategy.RiskScoreEntity.user), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "iInCircle",
      className: "eui-alignTop"
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: riskScore => {
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
          severity: riskScore
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }] : [])], [isPlatinumOrTrialLicense]);
  const relatedUsersCount = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, `${i18n.RELATED_USERS_TITLE}: ${totalCount}`)))), [totalCount]);
  const pagination = {
    pageSize: 4,
    showPerPageOptions: false
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.HOSTS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_entity_panel.EntityPanel, {
    title: hostName,
    iconType: 'storage',
    expandable: true,
    expanded: true,
    headerContent: relatedUsersCount,
    "data-test-subj": _test_ids.HOST_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.HOSTS_INFO_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(hostDetails),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(HostOverviewManage, {
    id: hostDetailsQueryId,
    hostName: hostName,
    data: hostDetails,
    indexNames: selectedPatterns,
    jobNameById: jobNameById,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    isInDetailsSidePanel: false,
    loading: isHostLoading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    deleteQuery: deleteQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.RELATED_USERS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.RELATED_USERS_TOOL_TIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "iInCircle",
    className: "eui-alignTop"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(RelatedUsersManage, {
    id: relatedUsersQueryId,
    inspect: inspectRelatedUsers,
    loading: isRelatedUsersLoading,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    refetch: refetchRelatedUsers
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: relatedUsersColumns,
    items: relatedUsers,
    loading: isRelatedUsersLoading,
    "data-test-subj": _test_ids.HOST_DETAILS_RELATED_USERS_TABLE_TEST_ID,
    pagination: pagination
  }), /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: relatedUsersQueryId,
    title: i18n.RELATED_USERS_TITLE,
    inspectIndex: 0
  }))));
};
exports.HostDetails = HostDetails;
HostDetails.displayName = 'HostDetails';