"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = exports.TIMESTAMP_DATE_FORMAT = exports.AlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _Either = require("fp-ts/lib/Either");
var _severity_badge = require("../../../detections/components/rules/severity_badge");
var _use_paginated_alerts = require("../hooks/use_paginated_alerts");
var _translations = require("../../shared/translations");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_DATE_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
exports.TIMESTAMP_DATE_FORMAT = TIMESTAMP_DATE_FORMAT;
const columns = [{
  field: '@timestamp',
  name: i18n.CORRELATIONS_TIMESTAMP_COLUMN_TITLE,
  truncateText: true,
  dataType: 'date',
  render: value => (0, _eui.formatDate)(value, TIMESTAMP_DATE_FORMAT)
}, {
  field: 'kibana.alert.rule.name',
  name: i18n.CORRELATIONS_RULE_COLUMN_TITLE,
  truncateText: true
}, {
  field: 'kibana.alert.reason',
  name: i18n.CORRELATIONS_REASON_COLUMN_TITLE,
  truncateText: true
}, {
  field: 'kibana.alert.severity',
  name: i18n.CORRELATIONS_SEVERITY_COLUMN_TITLE,
  truncateText: true,
  render: value => {
    const decodedSeverity = _securitysolutionIoTsAlertingTypes.Severity.decode(value);
    return (0, _Either.isRight)(decodedSeverity) ? /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: decodedSeverity.right
    }) : value;
  }
}];
exports.columns = columns;
/**
 * Renders paginated alert array based on the provided alertIds
 */
const AlertsTable = ({
  alertIds,
  'data-test-subj': dataTestSubj
}) => {
  const {
    setPagination,
    setSorting,
    data,
    loading,
    paginationConfig,
    sorting,
    error
  } = (0, _use_paginated_alerts.usePaginatedAlerts)(alertIds);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      const {
        index: pageIndex,
        size: pageSize
      } = page;
      setPagination({
        pageIndex,
        pageSize
      });
    }
    if (sort) {
      setSorting(sort);
    }
  }, [setPagination, setSorting]);
  const mappedData = (0, _react.useMemo)(() => {
    return data.map(hit => hit.fields).map((fields = {}) => Object.keys(fields).reduce((result, fieldName) => {
      var _fields$fieldName;
      result[fieldName] = (fields === null || fields === void 0 ? void 0 : (_fields$fieldName = fields[fieldName]) === null || _fields$fieldName === void 0 ? void 0 : _fields$fieldName[0]) || (fields === null || fields === void 0 ? void 0 : fields[fieldName]);
      return result;
    }, {}));
  }, [data]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, (0, _translations.ERROR_TITLE)('alert data')),
      body: /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.ERROR_MESSAGE)('alert data')),
      "data-test-subj": `${dataTestSubj}Error`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": dataTestSubj,
    loading: loading,
    items: mappedData,
    columns: columns,
    pagination: paginationConfig,
    sorting: sorting,
    onChange: onTableChange
  });
};
exports.AlertsTable = AlertsTable;